import { mount } from '@vue/test-utils'
import SimpleBoolean from 'src/components/simple/SimpleBoolean'

const factory = (propsData = {}) => {
    return mount(SimpleBoolean, {
        propsData
    })
}

describe('SimpleBoolean', () => {
    it('Should match the first snapshot', () => {
        let wrapper = factory({ value: true })
        expect(wrapper.element).toMatchSnapshot()
    })

    it('Should match the second snapshot', () => {
        let wrapper = factory({ value: false })
        expect(wrapper.element).toMatchSnapshot()
    })

    it('Should match the third snapshot', () => {
        let wrapper = factory({ value: false, classes: ['trueClass', 'falseClass'], texts: ['Yep', 'Nope'] })
        expect(wrapper.element).toMatchSnapshot()
    })
})
