import { shallowMount } from '@vue/test-utils'
import SimpleTable from 'src/components/simple/SimpleTable'
import { Checkbox } from 'element-ui'

const data = {
    tableFields: [
        { id: 'id', name: 'id-name' },
        { id: 'name', name: 'name' }
    ],

    items: [
        { id: 1, name: 'first' },
        { id: 2, name: 'second' },
        { id: 3, name: 'third' }
    ]
}

// fixme тесты не работают из-за проблем с импортом Checkbox

describe('SimpleTable', () => {
    it('Snapshot 1', () => {
        let wrapper = shallowMount(SimpleTable, {
            propsData: {
                ...data
            },
            components: { Checkbox }
        })

        expect(wrapper.element).toMatchSnapshot()
    })

    it('Snapshot 2', () => {
        let wrapper = shallowMount(SimpleTable, {
            propsData: {
                ...data,
                selectable: true,
                canSelectAll: true,
                selectedRows: []
            },
            components: { Checkbox }
        })

        expect(wrapper.element).toMatchSnapshot()
    })

    it('Snapshot 3', () => {
        let wrapper = shallowMount(SimpleTable, {
            propsData: {
                ...data,
                selectable: true,
                canSelectAll: true,
                selectedRows: [1, 2],
                tableClass: 'tableClass',
                headClass: 'headClass',
                rowClass: 'rowClass'
            },
            components: { Checkbox }
        })

        expect(wrapper.element).toMatchSnapshot()
    })
})
