import { difference } from 'src/utils/difference'

describe('Difference snapshot', () => {
    const o1 = {
        name: 'test1',
        description: '11111',
        regularityMonth: 0,
        regularityDay: 0,
        regularityHour: 0,
        attemptLimit: 5,
        attemptInterval: 15,
        periodBegin: new Date('2019-02-01T03:00:00.000Z'),
        periodEnd: new Date('2019-02-23T00:00:00.000Z'),
        relPeriodBegin: 0,
        relPeriodDuration: 0,
        isEnabled: true,
        isPublic: false
    }

    it('Snapshot Simple', () => {
        const o2 = {
            name: 'test2',
            description: '11113',
            regularityMonth: 0,
            regularityDay: 0,
            regularityHour: 0,
            attemptLimit: 5,
            attemptInterval: 15,
            periodBegin: new Date('2019-02-01T03:00:00.000Z'),
            periodEnd: new Date('2019-02-23T00:00:00.000Z'),
            relPeriodBegin: 0,
            relPeriodDuration: 0,
            isEnabled: true,
            isPublic: false
        }

        expect(difference(o1, o2)).toMatchSnapshot()
    })

    it('Snapshot All', () => {
        const o2 = {
            name: 'test3',
            description: '11114',
            regularityMonth: 5,
            regularityDay: 5,
            regularityHour: 6,
            attemptLimit: 5,
            attemptInterval: 15,
            periodBegin: new Date('2019-02-01T03:00:00.000Z'),
            periodEnd: new Date('2019-02-23T00:00:00.000Z'),
            relPeriodBegin: 0,
            relPeriodDuration: 0,
            isEnabled: false,
            isPublic: true
        }

        expect(difference(o1, o2)).toMatchSnapshot()
    })

    it('Snapshot Dates', () => {
        const o2 = {
            name: 'test1',
            description: '11111',
            regularityMonth: 0,
            regularityDay: 0,
            regularityHour: 0,
            attemptLimit: 5,
            attemptInterval: 15,
            periodBegin: new Date('2019-02-02T03:00:00.000Z'),
            periodEnd: new Date('2019-02-24T00:00:00.000Z'),
            relPeriodBegin: 0,
            relPeriodDuration: 0,
            isEnabled: true,
            isPublic: false
        }

        expect(difference(o1, o2)).toMatchSnapshot()
    })

    it('Snapshot Arrays', () => {
        const o1 = {
            test: []
        }
        const o2 = {
            test: [42, 1, 2, 3]
        }

        expect(difference(o1, o2)).toMatchSnapshot()
    })

    it('Snapshot null', () => {
        const o1 = {
            a: null
        }

        const o2 = {
            a: null,
            b: 42
        }

        expect(difference(o1, o2)).toMatchSnapshot()
    })

    it('Test same object', () => {
        const o1 = { a: 42 }

        expect(difference(o1, o1)).toBe(false)
    })
})
