import { dateFilter, bigNumFilter, percentFilter, roundFilter, ellipsisFilter } from 'src/utils/filters'

describe('dateFilter', () => {
    it('Null Values', () => {
        expect(dateFilter(null)).toBe('Без даты')
        expect(dateFilter()).toBe('Без даты')
    })

    it('Timestamp Values', () => {
        expect(dateFilter(1, 'd')).toBe('Jan 01 1970')
        expect(dateFilter(1, 'dt')).toBe('Jan 01 1970, 3:00:00 AM')
    })
})

describe('bigNumFilter', () => {
    it('Null Values', () => {
        expect(bigNumFilter(null)).toBe(null)
        expect(bigNumFilter()).toBe(undefined)
    })

    it('Values', () => {
        expect(bigNumFilter(1123123)).toBe('11,231.23')
        expect(bigNumFilter(-10000)).toBe('-100.00')
    })
})

describe('percentFilter', () => {
    it('Null Values', () => {
        expect(percentFilter(null)).toBe(null)
        expect(percentFilter()).toBe(undefined)
    })

    it('Values', () => {
        expect(percentFilter(0.5)).toBe('50%')
        expect(percentFilter(0.77)).toBe('77%')
    })
})

describe('roundFilter', () => {
    it('Null Values', () => {
        expect(roundFilter(null)).toBe(null)
        expect(roundFilter()).toBe(undefined)
    })

    it('Values', () => {
        expect(roundFilter(0.5)).toBe('0.50')
        expect(roundFilter(0.77)).toBe('0.77')
    })
})

describe('ellipsisFilter', () => {
    it('Null Values', () => {
        expect(ellipsisFilter(null)).toBe(null)
        expect(ellipsisFilter()).toBe(undefined)
    })

    it('Values', () => {
        expect(ellipsisFilter('ffffffffffffffffffffffffff')).toBe('fffffffffffffffffffffffff...')
    })
})
