import { getKeysOrNull, insertAfter, joinValuesOrNull } from 'src/utils/utils'

describe('getKeysOrNull', () => {
    it('Null Values', () => {
        expect(getKeysOrNull()).toBe(null)
        expect(getKeysOrNull(null, 'id')).toBe(null)
    })

    it('Ok values', () => {
        const values = getKeysOrNull([{ a: 42 }, { a: 43 }], 'a')
        expect(values).toEqual([42, 43])
    })
})

describe('joinValuesOrNull', () => {
    it('Null Values', () => {
        expect(joinValuesOrNull()).toBe(null)
        expect(joinValuesOrNull(null, 'id')).toBe(null)
    })

    it('Ok values', () => {
        const values = joinValuesOrNull([{ a: 42 }, { a: 43 }], 'a', ',')
        expect(values).toBe('42,43')
    })
})

describe('insertAfter', () => {
    it('inserts after leading true elements', () => {
        const arr = [true, true, false, false, true]
        insertAfter(arr, 1, (v) => v)
        expect(arr).toEqual([true, true, 1, false, false, true])
    })

    it('inserts at start if no matching', () => {
        const arr = [false, false, false, false]
        insertAfter(arr, 1, (v) => v)
        expect(arr).toEqual([1, false, false, false, false])
    })
})
