const path = require('path')

module.exports = {
    productionSourceMap: false,

    devServer: {
        public: 'localhost',
        proxy: {
            '/api': {
                target: 'http://188.68.16.188:8083',
                changeOrigin: false,
                secure: false
            }
        }
    },

    // src - Хитрый алиас для webpack.
    // WebStorm считает, что это обычные пути и продолжает понимать что происходит,
    // но `@` как алиас на /src/ по умолчанию не понимает без явного webpack конфига (а его нет)
    configureWebpack: {
        resolve: {
            alias: {
                'src': path.resolve(__dirname, 'src/')
            }
        }
    }
}
