import sys
import os
import yaml
import time


def get_value(yaml_data, keys, variable):
    try:
        k = keys.split(".")
        s = repr(yaml_data)
        for i in range(len(k)):
            s = s + "[k[{}]]".format(i)
        return eval(s)
    except Exception as err:
        print("Value {} not found in config".format(err))
        return variable


def parse_config(file_path):
    try:
        with open(file_path, "r", encoding="utf8") as config_file:
            config = yaml.load(config_file)
    except yaml.YAMLError as exc:
        print("Failed parse YAML config file: {}".format(exc))
        sys.exit(1)
    address = None
    address = get_value(config, "monitoring.mail_smtp.address", address)
    port = None
    port = get_value(config, "monitoring.mail_smtp.port", port)
    user = None
    user = get_value(config, "monitoring.mail_smtp.user", user)
    password = None
    password = get_value(config, "monitoring.mail_smtp.password", password)
    receiver_address = None
    receiver_address = get_value(config, "monitoring.systemd_notify_address", receiver_address)
    return address, port, user, password, receiver_address


def parse_state(file_path):
    if not os.path.isfile(file_path):
        with open(file_path, "w", encoding="utf8") as state_file:
            state_file.write(yaml.dump({"notify_time_marker": time.time()}))
        return True

    try:
        with open(file_path, "r", encoding="utf8") as state_file:
            state = yaml.load(state_file)
    except yaml.YAMLError as exc:
        print("Failed parse YAML config file: {}".format(exc))
        sys.exit(1)

    notify_time_marker = None
    notify_time_marker = get_value(state, "notify_time_marker", notify_time_marker)

    current_time = time.time()
    state['notify_time_marker'] = current_time

    with open(file_path, "w", encoding="utf8") as state_file:
        state_file.write(yaml.dump(state))

    if current_time - notify_time_marker >= 600:
        return True
    else:
        return False


is_send_email = parse_state("/var/opt/aisexpert/state/systemd.state")

if is_send_email:
    Address, Port, User, Password, Receiver_address = parse_config("/etc/aisexpert/aisexpert.conf")

    Message = os.popen('systemctl status aisexpert.service').read()

    command = 'echo "{}" | mailx -v ' \
              '-S smtp-use-starttls ' \
              '-S smtp=smtps://{}:{} ' \
              '-S from="{}" ' \
              '-S ssl-verify=ignore ' \
              '-S smtp-auth=login ' \
              '-S smtp-auth-user="{}" ' \
              '-S smtp-auth-password="{}" ' \
              '-s "Systemd notification: AisExpert failure" ' \
              '{}'.format(Message, Address, Port, User, User, Password, Receiver_address)

    print(command)
    os.system(command)
