/******************************************************************************/
/****                 Deactivating dependencies of objects                 ****/
/******************************************************************************/
ALTER TABLE SYNC_DATA
  ADD DATE_OT_PER DATE;

CREATE INDEX IDX_SYNC_DATA_DATE_OT_PER
  ON SYNC_DATA (DATE_OT_PER);

SET TERM ^ ;

ALTER PROCEDURE GET_APPLY_ROWS(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
RETURNS (
  GKEY CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  IDSL CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  MSK_OT VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MSK VARCHAR(20) /* COLLATE NONE - default */,
  VID_MP VARCHAR(20) /* COLLATE NONE - default */,
  USL_OK VARCHAR(20) /* COLLATE NONE - default */,
  PROFIL VARCHAR(20) /* COLLATE NONE - default */,
  MKB1 VARCHAR(5) /* COLLATE NONE - default */,
  MKB2 VARCHAR(5) /* COLLATE NONE - default */,
  CODE_USL VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MD VARCHAR(24) /* COLLATE NONE - default */,
  KOL_USL DOUBLE PRECISION,
  KOL_FACT DOUBLE PRECISION,
  ISH_MOV VARCHAR(20) /* COLLATE NONE - default */,
  RES_GOSP VARCHAR(20) /* COLLATE NONE - default */,
  TARIF_B DOUBLE PRECISION,
  TARIF_S DOUBLE PRECISION,
  TARIF_1K DOUBLE PRECISION,
  SUM_RUB DOUBLE PRECISION,
  VID_TR VARCHAR(20) /* COLLATE NONE - default */,
  EXTR VARCHAR(20) /* COLLATE NONE - default */,
  SOUF DOUBLE PRECISION,
  SPEC_MD VARCHAR(20) /* COLLATE NONE - default */,
  DOMC_TYPE VARCHAR(20) /* COLLATE NONE - default */,
  OKATO_INS VARCHAR(20) /* COLLATE NONE - default */,
  NOVOR VARCHAR(20) /* COLLATE NONE - default */,
  CODE_LPU VARCHAR(20) /* COLLATE NONE - default */,
  VID_SF DOUBLE PRECISION,
  PERSCODE VARCHAR(36) /* COLLATE NONE - default */,
  DATE_IN DATE,
  DATE_OUT DATE,
  TARIF_D DOUBLE PRECISION,
  VID_KOEFF DOUBLE PRECISION,
  USL_TMP DOUBLE PRECISION,
  BIRTHDAY DATE,
  SEX DOUBLE PRECISION,
  COUNTRY DOUBLE PRECISION,
  BIRTHDAY_P DATE,
  INV DOUBLE PRECISION,
  DATE_NPR DATE,
  FOR_POM DOUBLE PRECISION,
  MSE DOUBLE PRECISION,
  P_CEL VARCHAR(20) /* COLLATE NONE - default */,
  DN VARCHAR(20) /* COLLATE NONE - default */,
  MKB0 VARCHAR(5) /* COLLATE NONE - default */,
  DS_ONK DOUBLE PRECISION,
  KOL_DEF DOUBLE PRECISION,
  MKB_SHORT VARCHAR(5) /* COLLATE NONE - default */,
  MKB_SUPERSHORT VARCHAR(5) /* COLLATE NONE - default */,
  DATE_NPR_OF_WEEK DOUBLE PRECISION,
  DATE_NPR_MONTH DOUBLE PRECISION,
  DATE_NPR_DIF DOUBLE PRECISION,
  DATE_IN_OF_WEEK DOUBLE PRECISION,
  DATE_IN_MONTH DOUBLE PRECISION,
  DATE_OUT_OF_WEEK DOUBLE PRECISION,
  DATE_OUT_MONTH DOUBLE PRECISION,
  DATE_DIFF DOUBLE PRECISION,
  OLD_VAR DOUBLE PRECISION,
  SUM_PER_DAY DOUBLE PRECISION,
  KOL_USL_PER_DAY DOUBLE PRECISION,
  KOL_FACT_PER_DAY DOUBLE PRECISION,
  DATE_NPR_DIF_RATE DOUBLE PRECISION,
  KOL_USLKOL_FACT DOUBLE PRECISION,
  TARIF_BTARIF_D DOUBLE PRECISION,
  TARIF_BSUM_RUB DOUBLE PRECISION,
  KOL_USLKOL_FACT_P DOUBLE PRECISION,
  TARIF_BSUM_RUB_P DOUBLE PRECISION,
  KOL_USL_RATE DOUBLE PRECISION,
  KOL_FACT_RATE DOUBLE PRECISION,
  DIF_OT DOUBLE PRECISION,
  AGGR_LPU_KOL_DEF DOUBLE PRECISION,
  AGGR_LPU_COUNT DOUBLE PRECISION,
  AGGR_LPU_RATE DOUBLE PRECISION,
  AGGR_MSK_OT_KOL_DEF DOUBLE PRECISION,
  AGGR_MSK_OT_COUNT DOUBLE PRECISION,
  AGGR_MSK_OT_RATE DOUBLE PRECISION,
  IS_EKMP DOUBLE PRECISION,
  VID_PROV DOUBLE PRECISION,
  MKB0_ORD INTEGER,
  MKB1_ORD INTEGER,
  MKB2_ORD INTEGER,
  MKB1S_ORD INTEGER,
  MKB1SS_ORD INTEGER,
  CODE_USL_ORD INTEGER,
  CODE_MD_ORD INTEGER,
  PERSCODE_ORD INTEGER,
  MSK_OT_ORD INTEGER,
  CODE_MSK_ORD INTEGER,
  VID_MP_ORD INTEGER,
  USL_OK_ORD INTEGER,
  PROFIL_ORD INTEGER,
  ISH_MOV_ORD INTEGER,
  RES_GOSP_ORD INTEGER,
  SPEC_MD_ORD INTEGER,
  CODE_LPU_ORD INTEGER,
  VID_TR_ORD INTEGER,
  DOMC_TYPE_ORD INTEGER,
  OKATO_INS_ORD INTEGER,
  EXTR_ORD INTEGER,
  DN_ORD INTEGER,
  P_CEL_ORD INTEGER)
AS
BEGIN
  SUSPEND;
END
^

ALTER PROCEDURE GET_LEARN_ROWS(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
RETURNS (
  GKEY CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  IDSL CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  MSK_OT VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MSK VARCHAR(20) /* COLLATE NONE - default */,
  VID_MP VARCHAR(20) /* COLLATE NONE - default */,
  USL_OK VARCHAR(20) /* COLLATE NONE - default */,
  PROFIL VARCHAR(20) /* COLLATE NONE - default */,
  MKB1 VARCHAR(5) /* COLLATE NONE - default */,
  MKB2 VARCHAR(5) /* COLLATE NONE - default */,
  CODE_USL VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MD VARCHAR(24) /* COLLATE NONE - default */,
  KOL_USL DOUBLE PRECISION,
  KOL_FACT DOUBLE PRECISION,
  ISH_MOV VARCHAR(20) /* COLLATE NONE - default */,
  RES_GOSP VARCHAR(20) /* COLLATE NONE - default */,
  TARIF_B DOUBLE PRECISION,
  TARIF_S DOUBLE PRECISION,
  TARIF_1K DOUBLE PRECISION,
  SUM_RUB DOUBLE PRECISION,
  VID_TR VARCHAR(20) /* COLLATE NONE - default */,
  EXTR VARCHAR(20) /* COLLATE NONE - default */,
  SOUF DOUBLE PRECISION,
  SPEC_MD VARCHAR(20) /* COLLATE NONE - default */,
  DOMC_TYPE VARCHAR(20) /* COLLATE NONE - default */,
  OKATO_INS VARCHAR(20) /* COLLATE NONE - default */,
  NOVOR VARCHAR(20) /* COLLATE NONE - default */,
  CODE_LPU VARCHAR(20) /* COLLATE NONE - default */,
  VID_SF CHAR(10) /* COLLATE NONE - default */,
  PERSCODE VARCHAR(36) /* COLLATE NONE - default */,
  DATE_IN DATE,
  DATE_OUT DATE,
  TARIF_D DOUBLE PRECISION,
  VID_KOEFF DOUBLE PRECISION,
  USL_TMP DOUBLE PRECISION,
  BIRTHDAY DATE,
  SEX DOUBLE PRECISION,
  COUNTRY DOUBLE PRECISION,
  BIRTHDAY_P DATE,
  INV DOUBLE PRECISION,
  DATE_NPR DATE,
  FOR_POM DOUBLE PRECISION,
  MSE DOUBLE PRECISION,
  P_CEL VARCHAR(20) /* COLLATE NONE - default */,
  DN VARCHAR(20) /* COLLATE NONE - default */,
  MKB0 VARCHAR(5) /* COLLATE NONE - default */,
  DS_ONK DOUBLE PRECISION,
  KOL_DEF DOUBLE PRECISION,
  MKB_SHORT VARCHAR(5) /* COLLATE NONE - default */,
  MKB_SUPERSHORT VARCHAR(5) /* COLLATE NONE - default */,
  DATE_NPR_OF_WEEK DOUBLE PRECISION,
  DATE_NPR_MONTH DOUBLE PRECISION,
  DATE_NPR_DIF DOUBLE PRECISION,
  DATE_IN_OF_WEEK DOUBLE PRECISION,
  DATE_IN_MONTH DOUBLE PRECISION,
  DATE_OUT_OF_WEEK DOUBLE PRECISION,
  DATE_OUT_MONTH DOUBLE PRECISION,
  DATE_DIFF DOUBLE PRECISION,
  OLD_VAR DOUBLE PRECISION,
  SUM_PER_DAY DOUBLE PRECISION,
  KOL_USL_PER_DAY DOUBLE PRECISION,
  KOL_FACT_PER_DAY DOUBLE PRECISION,
  DATE_NPR_DIF_RATE DOUBLE PRECISION,
  KOL_USLKOL_FACT DOUBLE PRECISION,
  TARIF_BTARIF_D DOUBLE PRECISION,
  TARIF_BSUM_RUB DOUBLE PRECISION,
  KOL_USLKOL_FACT_P DOUBLE PRECISION,
  TARIF_BSUM_RUB_P DOUBLE PRECISION,
  KOL_USL_RATE DOUBLE PRECISION,
  KOL_FACT_RATE DOUBLE PRECISION,
  DIF_OT DOUBLE PRECISION,
  AGGR_LPU_KOL_DEF DOUBLE PRECISION,
  AGGR_LPU_COUNT DOUBLE PRECISION,
  AGGR_LPU_RATE DOUBLE PRECISION,
  AGGR_MSK_OT_KOL_DEF DOUBLE PRECISION,
  AGGR_MSK_OT_COUNT DOUBLE PRECISION,
  AGGR_MSK_OT_RATE DOUBLE PRECISION,
  IS_EKMP DOUBLE PRECISION,
  VID_PROV DOUBLE PRECISION,
  MKB0_ORD INTEGER,
  MKB1_ORD INTEGER,
  MKB2_ORD INTEGER,
  MKB1S_ORD INTEGER,
  MKB1SS_ORD INTEGER,
  CODE_USL_ORD INTEGER,
  CODE_MD_ORD INTEGER,
  PERSCODE_ORD INTEGER,
  MSK_OT_ORD INTEGER,
  CODE_MSK_ORD INTEGER,
  VID_MP_ORD INTEGER,
  USL_OK_ORD INTEGER,
  PROFIL_ORD INTEGER,
  ISH_MOV_ORD INTEGER,
  RES_GOSP_ORD INTEGER,
  SPEC_MD_ORD INTEGER,
  CODE_LPU_ORD INTEGER,
  VID_TR_ORD INTEGER,
  DOMC_TYPE_ORD INTEGER,
  OKATO_INS_ORD INTEGER,
  EXTR_ORD INTEGER,
  DN_ORD INTEGER,
  P_CEL_ORD INTEGER)
AS
BEGIN
  SUSPEND;
END
^

ALTER PROCEDURE GET_RECORDS_COUNT(
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MEE SMALLINT,
  EKMP SMALLINT)
RETURNS (
  REC_COUNT INTEGER)
AS
BEGIN
  SUSPEND;
END
^

ALTER PROCEDURE MAKE_AGGR(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
AS
BEGIN
  EXIT;
END
^

ALTER PROCEDURE MAKE_AGGR_TMP(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
AS
BEGIN
  EXIT;
END
^

ALTER PROCEDURE MAKE_DICTIONARY(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE)
AS
BEGIN
  EXIT;
END
^

ALTER PROCEDURE MAKE_DICTIONARY_MOST_FREQ(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE)
AS
BEGIN
  EXIT;
END
^

ALTER PROCEDURE MAKE_DICTIONARY_TMP(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE)
AS
BEGIN
  EXIT;
END
^

ALTER PROCEDURE MEDIAN_VALUES(
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
RETURNS (
  DATE_IN_RET DATE,
  DATE_OUT_RET DATE,
  BIRTHDAY_RET DATE,
  BIRTHDAY_P_RET DATE,
  DATE_NPR_RET DATE)
AS
BEGIN
  SUSPEND;
END
^

ALTER PROCEDURE GET_APPLY_ROWS(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
RETURNS (
  GKEY CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  IDSL CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  MSK_OT VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MSK VARCHAR(20) /* COLLATE NONE - default */,
  VID_MP VARCHAR(20) /* COLLATE NONE - default */,
  USL_OK VARCHAR(20) /* COLLATE NONE - default */,
  PROFIL VARCHAR(20) /* COLLATE NONE - default */,
  MKB1 VARCHAR(5) /* COLLATE NONE - default */,
  MKB2 VARCHAR(5) /* COLLATE NONE - default */,
  CODE_USL VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MD VARCHAR(24) /* COLLATE NONE - default */,
  KOL_USL DOUBLE PRECISION,
  KOL_FACT DOUBLE PRECISION,
  ISH_MOV VARCHAR(20) /* COLLATE NONE - default */,
  RES_GOSP VARCHAR(20) /* COLLATE NONE - default */,
  TARIF_B DOUBLE PRECISION,
  TARIF_S DOUBLE PRECISION,
  TARIF_1K DOUBLE PRECISION,
  SUM_RUB DOUBLE PRECISION,
  VID_TR VARCHAR(20) /* COLLATE NONE - default */,
  EXTR VARCHAR(20) /* COLLATE NONE - default */,
  SOUF DOUBLE PRECISION,
  SPEC_MD VARCHAR(20) /* COLLATE NONE - default */,
  DOMC_TYPE VARCHAR(20) /* COLLATE NONE - default */,
  OKATO_INS VARCHAR(20) /* COLLATE NONE - default */,
  NOVOR VARCHAR(20) /* COLLATE NONE - default */,
  CODE_LPU VARCHAR(20) /* COLLATE NONE - default */,
  VID_SF DOUBLE PRECISION,
  PERSCODE VARCHAR(36) /* COLLATE NONE - default */,
  DATE_IN DATE,
  DATE_OUT DATE,
  TARIF_D DOUBLE PRECISION,
  VID_KOEFF DOUBLE PRECISION,
  USL_TMP DOUBLE PRECISION,
  BIRTHDAY DATE,
  SEX DOUBLE PRECISION,
  COUNTRY DOUBLE PRECISION,
  BIRTHDAY_P DATE,
  INV DOUBLE PRECISION,
  DATE_NPR DATE,
  FOR_POM DOUBLE PRECISION,
  MSE DOUBLE PRECISION,
  P_CEL VARCHAR(20) /* COLLATE NONE - default */,
  DN VARCHAR(20) /* COLLATE NONE - default */,
  MKB0 VARCHAR(5) /* COLLATE NONE - default */,
  DS_ONK DOUBLE PRECISION,
  KOL_DEF DOUBLE PRECISION,
  MKB_SHORT VARCHAR(5) /* COLLATE NONE - default */,
  MKB_SUPERSHORT VARCHAR(5) /* COLLATE NONE - default */,
  DATE_NPR_OF_WEEK DOUBLE PRECISION,
  DATE_NPR_MONTH DOUBLE PRECISION,
  DATE_NPR_DIF DOUBLE PRECISION,
  DATE_IN_OF_WEEK DOUBLE PRECISION,
  DATE_IN_MONTH DOUBLE PRECISION,
  DATE_OUT_OF_WEEK DOUBLE PRECISION,
  DATE_OUT_MONTH DOUBLE PRECISION,
  DATE_DIFF DOUBLE PRECISION,
  OLD_VAR DOUBLE PRECISION,
  SUM_PER_DAY DOUBLE PRECISION,
  KOL_USL_PER_DAY DOUBLE PRECISION,
  KOL_FACT_PER_DAY DOUBLE PRECISION,
  DATE_NPR_DIF_RATE DOUBLE PRECISION,
  KOL_USLKOL_FACT DOUBLE PRECISION,
  TARIF_BTARIF_D DOUBLE PRECISION,
  TARIF_BSUM_RUB DOUBLE PRECISION,
  KOL_USLKOL_FACT_P DOUBLE PRECISION,
  TARIF_BSUM_RUB_P DOUBLE PRECISION,
  KOL_USL_RATE DOUBLE PRECISION,
  KOL_FACT_RATE DOUBLE PRECISION,
  DIF_OT DOUBLE PRECISION,
  AGGR_LPU_KOL_DEF DOUBLE PRECISION,
  AGGR_LPU_COUNT DOUBLE PRECISION,
  AGGR_LPU_RATE DOUBLE PRECISION,
  AGGR_MSK_OT_KOL_DEF DOUBLE PRECISION,
  AGGR_MSK_OT_COUNT DOUBLE PRECISION,
  AGGR_MSK_OT_RATE DOUBLE PRECISION,
  IS_EKMP DOUBLE PRECISION,
  VID_PROV DOUBLE PRECISION,
  MKB0_ORD INTEGER,
  MKB1_ORD INTEGER,
  MKB2_ORD INTEGER,
  MKB1S_ORD INTEGER,
  MKB1SS_ORD INTEGER,
  CODE_USL_ORD INTEGER,
  CODE_MD_ORD INTEGER,
  PERSCODE_ORD INTEGER,
  MSK_OT_ORD INTEGER,
  CODE_MSK_ORD INTEGER,
  VID_MP_ORD INTEGER,
  USL_OK_ORD INTEGER,
  PROFIL_ORD INTEGER,
  ISH_MOV_ORD INTEGER,
  RES_GOSP_ORD INTEGER,
  SPEC_MD_ORD INTEGER,
  CODE_LPU_ORD INTEGER,
  VID_TR_ORD INTEGER,
  DOMC_TYPE_ORD INTEGER,
  OKATO_INS_ORD INTEGER,
  EXTR_ORD INTEGER,
  DN_ORD INTEGER,
  P_CEL_ORD INTEGER)
AS
declare variable DATE_IN_MED date;
declare variable DATE_OUT_MED date;
declare variable BIRTHDAY_MED date;
declare variable BIRTHDAY_P_MED date;
declare variable DATE_NPR_MED date;
declare variable DATE_IN_VAR date;
declare variable DATE_OUT_VAR date;
declare variable BIRTHDAY_VAR date;
declare variable DATE_NPR_VAR date;
declare variable MODEL_ID_VAR char(16) character set OCTETS;
declare variable MKB0_VAR varchar(5);
declare variable MKB1_VAR varchar(5);
declare variable MKB2_VAR varchar(5);
declare variable MKB1_S_VAR varchar(5);
declare variable MKB1_SS_VAR varchar(5);
declare variable CODE_USL_VAR varchar(15);
declare variable CODE_MD_VAR varchar(24);
declare variable PERSCODE_VAR varchar(36);
declare variable MSK_OT_VAR varchar(20);
declare variable CODE_MSK_VAR varchar(20);
declare variable VID_MP_VAR varchar(20);
declare variable USL_OK_VAR varchar(20);
declare variable PROFIL_VAR varchar(20);
declare variable ISH_MOV_VAR varchar(20);
declare variable RES_GOSP_VAR varchar(20);
declare variable SPEC_MD_VAR varchar(20);
declare variable CODE_LPU_VAR varchar(20);
declare variable VID_TR_VAR varchar(20);
declare variable DOMC_TYPE_VAR varchar(20);
declare variable OKATO_INS_VAR varchar(20);
declare variable EXTR_VAR varchar(20);
declare variable DN_VAR varchar(20);
declare variable P_CEL_VAR varchar(20);
declare variable MEE_VAL smallint;
declare variable EKMP_VAL smallint;
begin

if (:model_type = 0) then
begin
  :MEE_VAL = -1;
  :EKMP_VAL = 2;
end
else
begin
  :MEE_VAL = 2;
  :EKMP_VAL = -1;
end

select
  DATE_IN_RET, DATE_OUT_RET, BIRTHDAY_RET, BIRTHDAY_P_RET, DATE_NPR_RET
from
  MEDIAN_VALUES(:PERIOD_BEGIN, :PERIOD_END, :MODEL_TYPE)
into
  DATE_IN_MED, DATE_OUT_MED, BIRTHDAY_MED, BIRTHDAY_P_MED, DATE_NPR_MED;

:MODEL_ID_VAR = :MODEL_ID;

EXECUTE PROCEDURE make_dictionary_tmp(:MODEL_ID_VAR, :PERIOD_BEGIN, :PERIOD_END);
EXECUTE PROCEDURE MAKE_AGGR_tmp(:MODEL_ID_VAR, :PERIOD_BEGIN, :PERIOD_END, :MODEL_TYPE);

for select
  GKEY,
  IDSL,
  MSK_OT,
  CODE_MSK,
  VID_MP,
  USL_OK,
  PROFIL,
  MKB1,
  MKB2,
  CODE_USL,
  CODE_MD,
  cast(KOL_USL as float),
  cast(KOL_FACT as float),
  ISH_MOV,
  RES_GOSP,
  cast(TARIF_B as float),
  cast(TARIF_S as float),
  cast(TARIF_1K as float),
  cast(SUM_RUB as float),
  VID_TR,
  cast(EXTR as varchar(20)),
  cast(SOUF as float),
  SPEC_MD,
  DOMC_TYPE,
  OKATO_INS,
  cast(NOVOR as varchar(20)),
  CODE_LPU,
  cast(VID_SF as float),
  PERSCODE,
  cast(TARIF_D as float),
  cast(VID_KOEFF as float),
  cast(USL_TMP as float),
  cast(SEX as float),
  cast(COUNTRY as float),
  cast(INV as float),
  cast(FOR_POM as float),
  cast(COALESCE(MSE, 0) as float),
  P_CEL,
  cast(DN as varchar(20)),
  MKB0,
  cast(DS_ONK as float),
  DATE_IN,
  DATE_OUT,
  DATE_NPR,
  BIRTHDAY,
  BIRTHDAY_P,
  SUBSTRING(MKB1 FROM 1 FOR 4) as MKB_SHORT,
  SUBSTRING(MKB1 FROM 1 FOR 1) as MKB_SUPERSHORT,
  :DATE_NPR_OF_WEEK,
  :DATE_NPR_MONTH,
  :DATE_NPR_DIF,
  :DATE_IN_OF_WEEK,
  :DATE_IN_MONTH,
  :DATE_OUT_OF_WEEK,
  :DATE_OUT_MONTH,
  :DATE_DIFF,
  :OLD_VAR,
  :Sum_per_Day,
  :KOL_USL_per_Day,
  :KOL_FACT_per_Day,
  :DATE_NPR_DIF_RATE,
  :KOL_USLKOL_FACT,
  :TARIF_BTARIF_D,
  :TARIF_BSUM_RUB,
  :KOL_USLKOL_FACT_P,
  :TARIF_BSUM_RUB_P,
  :KOL_USL_RATE,
  :KOL_FACT_RATE,
  :DIF_OT,
  case
    when :MODEL_TYPE = 0 and MEE > 0 then 1
    when :MODEL_TYPE = 1 and EKMP > 0 then 1
    else 0
  end as KOL_DEF,
  :aggr_lpu_KOL_DEF,
  :aggr_lpu_COUNT,
  :aggr_lpu_RATE,
  :aggr_MSK_OT_KOL_DEF,
  :aggr_MSK_OT_COUNT,
  :aggr_MSK_OT_RATE,
  :IS_EKMP as IS_EKMP,
  VID_PROV,
  :MKB0_ORD,
  :MKB1_ORD,
  :MKB2_ORD,
  :MKB1S_ORD,
  :MKB1SS_ORD,
  :CODE_USL_ORD,
  :CODE_MD_ORD,
  :PERSCODE_ORD,
  :MSK_OT_ORD,
  :CODE_MSK_ORD,
  :VID_MP_ORD,
  :USL_OK_ORD,
  :PROFIL_ORD,
  :ISH_MOV_ORD,
  :RES_GOSP_ORD,
  :SPEC_MD_ORD,
  :CODE_LPU_ORD,
  :VID_TR_ORD,
  :DOMC_TYPE_ORD,
  :OKATO_INS_ORD,
  :P_CEL_ORD
from
  sync_data where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
into
  :GKEY,
  :IDSL,
  :MSK_OT,
  :CODE_MSK,
  :VID_MP,
  :USL_OK,
  :PROFIL,
  :MKB1,
  :MKB2,
  :CODE_USL,
  :CODE_MD,
  :KOL_USL,
  :KOL_FACT,
  :ISH_MOV,
  :RES_GOSP,
  :TARIF_B,
  :TARIF_S,
  :TARIF_1K,
  :SUM_RUB,
  :VID_TR,
  :EXTR,
  :SOUF,
  :SPEC_MD,
  :DOMC_TYPE,
  :OKATO_INS,
  :NOVOR,
  :CODE_LPU,
  :VID_SF,
  :PERSCODE,
  :TARIF_D,
  :VID_KOEFF,
  :USL_TMP,
  :SEX,
  :COUNTRY,
  :INV,
  :FOR_POM,
  :MSE,
  :P_CEL,
  :DN,
  :MKB0,
  :DS_ONK,
  :DATE_IN,
  :DATE_OUT,
  :DATE_NPR,
  :BIRTHDAY,
  :BIRTHDAY_P,
  :MKB_SHORT,
  :MKB_SUPERSHORT,
  :DATE_NPR_OF_WEEK,
  :DATE_NPR_MONTH,
  :DATE_NPR_DIF,
  :DATE_IN_OF_WEEK,
  :DATE_IN_MONTH,
  :DATE_OUT_OF_WEEK,
  :DATE_OUT_MONTH,
  :DATE_DIFF,
  :OLD_VAR,
  :Sum_per_Day,
  :KOL_USL_per_Day,
  :KOL_FACT_per_Day,
  :DATE_NPR_DIF_RATE,
  :KOL_USLKOL_FACT,
  :TARIF_BTARIF_D,
  :TARIF_BSUM_RUB,
  :KOL_USLKOL_FACT_P,
  :TARIF_BSUM_RUB_P,
  :KOL_USL_RATE,
  :KOL_FACT_RATE,
  :DIF_OT,
  :KOL_DEF,
  :aggr_lpu_KOL_DEF,
  :aggr_lpu_COUNT,
  :aggr_lpu_RATE,
  :aggr_MSK_OT_KOL_DEF,
  :aggr_MSK_OT_COUNT,
  :aggr_MSK_OT_RATE,
  :IS_EKMP,
  :VID_PROV,
  :MKB0_ORD,
  :MKB1_ORD,
  :MKB2_ORD,
  :MKB1S_ORD,
  :MKB1SS_ORD,
  :CODE_USL_ORD,
  :CODE_MD_ORD,
  :PERSCODE_ORD,
  :MSK_OT_ORD,
  :CODE_MSK_ORD,
  :VID_MP_ORD,
  :USL_OK_ORD,
  :PROFIL_ORD,
  :ISH_MOV_ORD,
  :RES_GOSP_ORD,
  :SPEC_MD_ORD,
  :CODE_LPU_ORD,
  :VID_TR_ORD,
  :DOMC_TYPE_ORD,
  :OKATO_INS_ORD,
  :P_CEL_ORD
do
begin
  if (MSK_OT is null ) then MSK_OT = 'zero'; else MSK_OT = MSK_OT;

  if (CODE_MSK is null ) then CODE_MSK = 'zero'; else CODE_MSK = CODE_MSK;

  if (VID_MP is null ) then VID_MP = 'zero'; else VID_MP = VID_MP;

  if (USL_OK is null ) then USL_OK = 'zero'; else USL_OK = USL_OK;

  if (PROFIL is null ) then PROFIL = 'zero'; else PROFIL = PROFIL;

  if (MKB1 is null ) then MKB1 = 'zero'; else MKB1 = MKB1;

  if (MKB2 is null ) then MKB2 = 'zero'; else MKB2 = MKB2;

  if (CODE_USL is null ) then CODE_USL = 'zero'; else CODE_USL = CODE_USL;

  if (CODE_MD is null ) then CODE_MD = 'zero'; else CODE_MD = CODE_MD;

  if (KOL_USL is null ) then KOL_USL = 0; else KOL_USL = KOL_USL;

  if (KOL_FACT is null ) then KOL_FACT = 0; else KOL_FACT = KOL_FACT;

  if (ISH_MOV is null ) then ISH_MOV = 'zero'; else ISH_MOV = ISH_MOV;

  if (RES_GOSP is null ) then RES_GOSP = 'zero'; else RES_GOSP = RES_GOSP;

  if (TARIF_B is null ) then TARIF_B = 0; else TARIF_B = TARIF_B;

  if (TARIF_S is null ) then TARIF_S = 0; else TARIF_S = TARIF_S;

  if (TARIF_1K is null ) then TARIF_1K = 0; else TARIF_1K = TARIF_1K;

  if (SUM_RUB is null ) then SUM_RUB = 0; else SUM_RUB = SUM_RUB;

  if (VID_TR is null ) then VID_TR = 'zero'; else VID_TR = VID_TR;

  if (EXTR is null ) then EXTR = 'zero'; else EXTR = EXTR;

  if (SOUF is null ) then SOUF = 0; else SOUF = SOUF;

  if (SPEC_MD is null ) then SPEC_MD = 'zero'; else SPEC_MD = SPEC_MD;

  if (DOMC_TYPE is null ) then DOMC_TYPE = 'zero'; else DOMC_TYPE = DOMC_TYPE;

  if (OKATO_INS is null ) then OKATO_INS = 'zero'; else OKATO_INS = OKATO_INS;

  if (NOVOR is null ) then NOVOR = 0; else NOVOR = NOVOR;

  if (CODE_LPU is null ) then CODE_LPU = 'zero'; else CODE_LPU = CODE_LPU;

  if (VID_SF is null ) then VID_SF = 0; else VID_SF = VID_SF;

  if (PERSCODE is null ) then PERSCODE = 'zero'; else PERSCODE = PERSCODE;

  if (TARIF_D is null ) then TARIF_D = 0; else TARIF_D = TARIF_D;

  if (VID_KOEFF is null ) then VID_KOEFF = 0; else VID_KOEFF = VID_KOEFF;

  if (USL_TMP is null ) then USL_TMP = 0; else USL_TMP = USL_TMP;

  if (SEX is null ) then SEX = 0; else SEX = SEX;

  if (COUNTRY is null ) then COUNTRY = 0; else COUNTRY = COUNTRY;

  if (INV is null ) then INV = 0; else INV = INV;

  if (FOR_POM is null ) then FOR_POM = 0; else FOR_POM = FOR_POM;

  if (MSE is null ) then MSE = 0; else MSE = MSE;

  if (P_CEL is null ) then P_CEL = 'zero'; else P_CEL = P_CEL;

  if (DN is null ) then DN = 'zero'; else DN = DN;

  if (MKB0 is null ) then MKB0 = 'zero'; else MKB0 = MKB0;

  :MKB0_VAR = MKB0;
  :MKB1_VAR = MKB1;
  :MKB2_VAR = MKB2;

  :MKB1_S_VAR = MKB_SHORT;
  :MKB1_SS_VAR = MKB_SUPERSHORT;

  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB0' and md.val = :MKB0_VAR into :MKB0_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB1' and md.val = :MKB1_VAR into :MKB1_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB2' and md.val = :MKB2_VAR into :MKB2_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB1_SHORT' and md.val = :MKB1_S_VAR into :MKB1S_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB1_SUPERSHORT' and md.val = :MKB1_SS_VAR into :MKB1SS_ORD;

  :CODE_USL_VAR = :CODE_USL;
  :CODE_MD_VAR = :CODE_MD;

  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_USL' and md.val = :CODE_USL_VAR into :CODE_USL_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_MD' and md.val = :CODE_MD_VAR into :CODE_MD_ORD;

  :PERSCODE_VAR = :PERSCODE;

  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'PERSCODE' and md.val = :PERSCODE_VAR into :PERSCODE_ORD;

  :CODE_LPU_VAR = :CODE_LPU;

  select CNT, DEF FROM model_aggr_tmp mla where mla.model_id = :MODEL_ID_VAR and mla.KIND = :MODEL_TYPE and mla.var = 'CODE_LPU' and mla.val = :CODE_LPU_VAR into :aggr_lpu_COUNT, :aggr_lpu_KOL_DEF;
  :aggr_lpu_RATE = (:aggr_lpu_KOL_DEF + 1) / (:aggr_lpu_COUNT + 10);

  :MSK_OT_VAR = :MSK_OT;
  :CODE_MSK_VAR = :CODE_MSK;
  :VID_MP_VAR = :VID_MP;
  :USL_OK_VAR = :USL_OK;
  :PROFIL_VAR = :PROFIL;
  :ISH_MOV_VAR = :ISH_MOV;
  :RES_GOSP_VAR = :RES_GOSP;
  :SPEC_MD_VAR = :SPEC_MD;
  :VID_TR_VAR = :VID_TR;
  :DOMC_TYPE_VAR = :DOMC_TYPE;
  :OKATO_INS_VAR = :OKATO_INS;
  :EXTR_VAR = :EXTR;
  :DN_VAR = :DN;
  :P_CEL_VAR = :P_CEL;

  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MSK_OT' and md.val = :MSK_OT_VAR into :MSK_OT_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_MSK' and md.val = :CODE_MSK_VAR into :CODE_MSK_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'VID_MP' and md.val = :VID_MP_VAR into :VID_MP_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'USL_OK' and md.val = :USL_OK_VAR into :USL_OK_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'PROFIL' and md.val = :PROFIL_VAR into :PROFIL_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'ISH_MOV' and md.val = :ISH_MOV_VAR into :ISH_MOV_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'RES_GOSP' and md.val = :RES_GOSP_VAR into :RES_GOSP_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'SPEC_MD' and md.val = :SPEC_MD_VAR into :SPEC_MD_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_LPU' and md.val = :CODE_LPU_VAR into :CODE_LPU_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'VID_TR' and md.val = :VID_TR_VAR into :VID_TR_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'DOMC_TYPE' and md.val = :DOMC_TYPE_VAR into :DOMC_TYPE_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'OKATO_INS' and md.val = :OKATO_INS_VAR into :OKATO_INS_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'EXTR' and md.val = :EXTR_VAR into :EXTR_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'DN' and md.val = :DN_VAR into :DN_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'P_CEL' and md.val = :P_CEL_VAR into :P_CEL_ORD;

  select CNT, DEF FROM model_aggr_tmp mmoa where mmoa.model_id = :MODEL_ID_VAR and mmoa.KIND = :MODEL_TYPE and mmoa.var = 'MSK_OT' and mmoa.val = :MSK_OT_VAR into :AGGR_MSK_OT_COUNT, :AGGR_MSK_OT_KOL_DEF;
  :aggr_MSK_OT_RATE = (aggr_MSK_OT_KOL_DEF + 1) / cast((AGGR_MSK_OT_COUNT + 10) as float);

  if (DS_ONK is null ) then DS_ONK = 0; else DS_ONK = DS_ONK;

  if (DATE_IN is null )
  then
  begin
    DATE_IN = DATE_IN_MED;
    DATE_IN_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_IN_MED);
    DATE_IN_MONTH = EXTRACT(DAY FROM DATE_IN_MED);
  end
  else
  begin
    DATE_IN = DATE_IN;
    DATE_IN_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_IN);
    DATE_IN_MONTH = EXTRACT(DAY FROM DATE_IN);
  end

  DATE_IN_VAR = DATE_IN;

  if (DATE_OUT is null )
  then
  begin
    DATE_OUT = DATE_OUT_MED;
    DATE_OUT_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_OUT_MED);
    DATE_OUT_MONTH = EXTRACT(DAY FROM DATE_OUT_MED);
  end
  else
  begin
    DATE_OUT = DATE_OUT;
    DATE_OUT_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_OUT);
    DATE_OUT_MONTH = EXTRACT(DAY FROM DATE_OUT);
  end

  DATE_OUT_VAR = DATE_OUT;

  if (DATE_NPR is null )
  then
  begin
    DATE_NPR = DATE_NPR_MED;
    DATE_NPR_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_NPR_MED);
    DATE_NPR_MONTH = EXTRACT(DAY FROM DATE_NPR_MED);
  end
  else
  begin
    DATE_NPR = DATE_NPR;
    DATE_NPR_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_NPR);
    DATE_NPR_MONTH = EXTRACT(DAY FROM DATE_NPR);
  end

  DATE_NPR_VAR = DATE_NPR;

  DATE_NPR_DIF = datediff (day, DATE_NPR_VAR, DATE_IN_VAR) + 1/cast(6 as float);

  DATE_DIFF = cast( datediff (day, DATE_OUT_VAR, DATE_IN_VAR) as float) + 1/cast(6 as float);

  if (BIRTHDAY is null ) then BIRTHDAY = BIRTHDAY_MED; else BIRTHDAY = BIRTHDAY;

  BIRTHDAY_VAR = BIRTHDAY;

  if (BIRTHDAY_P is null ) then BIRTHDAY_P = BIRTHDAY_P_MED; else BIRTHDAY_P = BIRTHDAY_P;

  OLD_VAR =  cast( datediff (year, DATE_IN_VAR, BIRTHDAY_VAR) as float);

  Sum_per_Day = SUM_RUB / cast(DATE_DIFF as float);

  KOL_USL_per_Day =   KOL_USL /  cast(DATE_DIFF as float);

  KOL_FACT_per_Day = KOL_FACT / cast(DATE_DIFF as float);

  DATE_NPR_DIF_RATE = DATE_NPR_DIF / cast(DATE_DIFF as float);

  KOL_USLKOL_FACT = KOL_USL - KOL_FACT;
  TARIF_BTARIF_D = TARIF_B- TARIF_D;
  TARIF_BSUM_RUB = TARIF_B - SUM_RUB;
  KOL_USLKOL_FACT_p = KOL_USL + KOL_FACT;
  TARIF_BSUM_RUB_p = TARIF_B + SUM_RUB;
  KOL_USL_rate = SUM_RUB / ( KOL_USL + 0.01);
  KOL_FACT_rate = SUM_RUB / ( KOL_FACT + 0.01);

  if (NOVOR = 0)
  then       
     NOVOR = 0;
  else
     NOVOR = 1;

  if (SEX = 2)
  then
     SEX = 1;
  else
     SEX = 0;

  if (MSK_OT <> CODE_MSK)
  then
     DIF_OT = 1;
  else
     DIF_OT = 0;

  IS_EKMP = 0;

  suspend;
end

end
^

ALTER PROCEDURE GET_LEARN_ROWS(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
RETURNS (
  GKEY CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  IDSL CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  MSK_OT VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MSK VARCHAR(20) /* COLLATE NONE - default */,
  VID_MP VARCHAR(20) /* COLLATE NONE - default */,
  USL_OK VARCHAR(20) /* COLLATE NONE - default */,
  PROFIL VARCHAR(20) /* COLLATE NONE - default */,
  MKB1 VARCHAR(5) /* COLLATE NONE - default */,
  MKB2 VARCHAR(5) /* COLLATE NONE - default */,
  CODE_USL VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MD VARCHAR(24) /* COLLATE NONE - default */,
  KOL_USL DOUBLE PRECISION,
  KOL_FACT DOUBLE PRECISION,
  ISH_MOV VARCHAR(20) /* COLLATE NONE - default */,
  RES_GOSP VARCHAR(20) /* COLLATE NONE - default */,
  TARIF_B DOUBLE PRECISION,
  TARIF_S DOUBLE PRECISION,
  TARIF_1K DOUBLE PRECISION,
  SUM_RUB DOUBLE PRECISION,
  VID_TR VARCHAR(20) /* COLLATE NONE - default */,
  EXTR VARCHAR(20) /* COLLATE NONE - default */,
  SOUF DOUBLE PRECISION,
  SPEC_MD VARCHAR(20) /* COLLATE NONE - default */,
  DOMC_TYPE VARCHAR(20) /* COLLATE NONE - default */,
  OKATO_INS VARCHAR(20) /* COLLATE NONE - default */,
  NOVOR VARCHAR(20) /* COLLATE NONE - default */,
  CODE_LPU VARCHAR(20) /* COLLATE NONE - default */,
  VID_SF CHAR(10) /* COLLATE NONE - default */,
  PERSCODE VARCHAR(36) /* COLLATE NONE - default */,
  DATE_IN DATE,
  DATE_OUT DATE,
  TARIF_D DOUBLE PRECISION,
  VID_KOEFF DOUBLE PRECISION,
  USL_TMP DOUBLE PRECISION,
  BIRTHDAY DATE,
  SEX DOUBLE PRECISION,
  COUNTRY DOUBLE PRECISION,
  BIRTHDAY_P DATE,
  INV DOUBLE PRECISION,
  DATE_NPR DATE,
  FOR_POM DOUBLE PRECISION,
  MSE DOUBLE PRECISION,
  P_CEL VARCHAR(20) /* COLLATE NONE - default */,
  DN VARCHAR(20) /* COLLATE NONE - default */,
  MKB0 VARCHAR(5) /* COLLATE NONE - default */,
  DS_ONK DOUBLE PRECISION,
  KOL_DEF DOUBLE PRECISION,
  MKB_SHORT VARCHAR(5) /* COLLATE NONE - default */,
  MKB_SUPERSHORT VARCHAR(5) /* COLLATE NONE - default */,
  DATE_NPR_OF_WEEK DOUBLE PRECISION,
  DATE_NPR_MONTH DOUBLE PRECISION,
  DATE_NPR_DIF DOUBLE PRECISION,
  DATE_IN_OF_WEEK DOUBLE PRECISION,
  DATE_IN_MONTH DOUBLE PRECISION,
  DATE_OUT_OF_WEEK DOUBLE PRECISION,
  DATE_OUT_MONTH DOUBLE PRECISION,
  DATE_DIFF DOUBLE PRECISION,
  OLD_VAR DOUBLE PRECISION,
  SUM_PER_DAY DOUBLE PRECISION,
  KOL_USL_PER_DAY DOUBLE PRECISION,
  KOL_FACT_PER_DAY DOUBLE PRECISION,
  DATE_NPR_DIF_RATE DOUBLE PRECISION,
  KOL_USLKOL_FACT DOUBLE PRECISION,
  TARIF_BTARIF_D DOUBLE PRECISION,
  TARIF_BSUM_RUB DOUBLE PRECISION,
  KOL_USLKOL_FACT_P DOUBLE PRECISION,
  TARIF_BSUM_RUB_P DOUBLE PRECISION,
  KOL_USL_RATE DOUBLE PRECISION,
  KOL_FACT_RATE DOUBLE PRECISION,
  DIF_OT DOUBLE PRECISION,
  AGGR_LPU_KOL_DEF DOUBLE PRECISION,
  AGGR_LPU_COUNT DOUBLE PRECISION,
  AGGR_LPU_RATE DOUBLE PRECISION,
  AGGR_MSK_OT_KOL_DEF DOUBLE PRECISION,
  AGGR_MSK_OT_COUNT DOUBLE PRECISION,
  AGGR_MSK_OT_RATE DOUBLE PRECISION,
  IS_EKMP DOUBLE PRECISION,
  VID_PROV DOUBLE PRECISION,
  MKB0_ORD INTEGER,
  MKB1_ORD INTEGER,
  MKB2_ORD INTEGER,
  MKB1S_ORD INTEGER,
  MKB1SS_ORD INTEGER,
  CODE_USL_ORD INTEGER,
  CODE_MD_ORD INTEGER,
  PERSCODE_ORD INTEGER,
  MSK_OT_ORD INTEGER,
  CODE_MSK_ORD INTEGER,
  VID_MP_ORD INTEGER,
  USL_OK_ORD INTEGER,
  PROFIL_ORD INTEGER,
  ISH_MOV_ORD INTEGER,
  RES_GOSP_ORD INTEGER,
  SPEC_MD_ORD INTEGER,
  CODE_LPU_ORD INTEGER,
  VID_TR_ORD INTEGER,
  DOMC_TYPE_ORD INTEGER,
  OKATO_INS_ORD INTEGER,
  EXTR_ORD INTEGER,
  DN_ORD INTEGER,
  P_CEL_ORD INTEGER)
AS
declare variable DATE_IN_MED date;
declare variable DATE_OUT_MED date;
declare variable BIRTHDAY_MED date;
declare variable BIRTHDAY_P_MED date;
declare variable DATE_NPR_MED date;
declare variable DATE_IN_VAR date;
declare variable DATE_OUT_VAR date;
declare variable BIRTHDAY_VAR date;
declare variable DATE_NPR_VAR date;
declare variable MODEL_ID_VAR char(16) character set OCTETS;
declare variable MKB0_VAR varchar(5);
declare variable MKB1_VAR varchar(5);
declare variable MKB2_VAR varchar(5);
declare variable MKB1_S_VAR varchar(5);
declare variable MKB1_SS_VAR varchar(5);
declare variable CODE_USL_VAR varchar(15);
declare variable CODE_MD_VAR varchar(24);
declare variable PERSCODE_VAR varchar(36);
declare variable MSK_OT_VAR varchar(20);
declare variable CODE_MSK_VAR varchar(20);
declare variable VID_MP_VAR varchar(20);
declare variable USL_OK_VAR varchar(20);
declare variable PROFIL_VAR varchar(20);
declare variable ISH_MOV_VAR varchar(20);
declare variable RES_GOSP_VAR varchar(20);
declare variable SPEC_MD_VAR varchar(20);
declare variable CODE_LPU_VAR varchar(20);
declare variable VID_TR_VAR varchar(20);
declare variable DOMC_TYPE_VAR varchar(20);
declare variable OKATO_INS_VAR varchar(20);
declare variable EXTR_VAR varchar(20);
declare variable DN_VAR varchar(20);
declare variable P_CEL_VAR varchar(20);
declare variable MEE_VAL smallint;
declare variable EKMP_VAL smallint;
begin

if (:model_type = 0) then
begin
  :MEE_VAL = 0;
  :EKMP_VAL = 2;
end
else
begin
  :MEE_VAL = 2;
  :EKMP_VAL = 0;
end

select
  DATE_IN_RET, DATE_OUT_RET, BIRTHDAY_RET, BIRTHDAY_P_RET, DATE_NPR_RET
from
  MEDIAN_VALUES(:PERIOD_BEGIN, :PERIOD_END, :MODEL_TYPE)
into
  DATE_IN_MED, DATE_OUT_MED, BIRTHDAY_MED, BIRTHDAY_P_MED, DATE_NPR_MED;

:MODEL_ID_VAR = :MODEL_ID;

for select
  GKEY,
  IDSL,
  MSK_OT,
  CODE_MSK,
  VID_MP,
  USL_OK,
  PROFIL,
  MKB1,
  MKB2,
  CODE_USL,
  CODE_MD,
  cast(KOL_USL as float),
  cast(KOL_FACT as float),
  ISH_MOV,
  RES_GOSP,
  cast(TARIF_B as float),
  cast(TARIF_S as float),
  cast(TARIF_1K as float),
  cast(SUM_RUB as float),
  VID_TR,
  cast(EXTR as varchar(20)),
  cast(SOUF as float),
  SPEC_MD,
  DOMC_TYPE,
  OKATO_INS,
  cast(NOVOR as varchar(20)),
  CODE_LPU,
  cast(VID_SF as float),
  PERSCODE,
  cast(TARIF_D as float),
  cast(VID_KOEFF as float),
  cast(USL_TMP as float),
  cast(SEX as float),
  cast(COUNTRY as float),
  cast(INV as float),
  cast(FOR_POM as float),
  cast(COALESCE(MSE, 0) as float),
  P_CEL,
  cast(DN as varchar(20)),
  MKB0,
  cast(DS_ONK as float),
  DATE_IN,
  DATE_OUT,
  DATE_NPR,
  BIRTHDAY,
  BIRTHDAY_P,
  SUBSTRING(MKB1 FROM 1 FOR 4) as MKB_SHORT,
  SUBSTRING(MKB1 FROM 1 FOR 1) as MKB_SUPERSHORT,
  :DATE_NPR_OF_WEEK,
  :DATE_NPR_MONTH,
  :DATE_NPR_DIF,
  :DATE_IN_OF_WEEK,
  :DATE_IN_MONTH,
  :DATE_OUT_OF_WEEK,
  :DATE_OUT_MONTH,
  :DATE_DIFF,
  :OLD_VAR,
  :Sum_per_Day,
  :KOL_USL_per_Day,
  :KOL_FACT_per_Day,
  :DATE_NPR_DIF_RATE,
  :KOL_USLKOL_FACT,
  :TARIF_BTARIF_D,
  :TARIF_BSUM_RUB,
  :KOL_USLKOL_FACT_P,
  :TARIF_BSUM_RUB_P,
  :KOL_USL_RATE,
  :KOL_FACT_RATE,
  :DIF_OT,
  case
    when :MODEL_TYPE = 0 and MEE > 0 then 1
    when :MODEL_TYPE = 1 and EKMP > 0 then 1
    else 0
  end as KOL_DEF,
  :aggr_lpu_KOL_DEF,
  :aggr_lpu_COUNT,
  :aggr_lpu_RATE,
  :aggr_MSK_OT_KOL_DEF,
  :aggr_MSK_OT_COUNT,
  :aggr_MSK_OT_RATE,
  :IS_EKMP as IS_EKMP,
  VID_PROV,
  :MKB0_ORD,
  :MKB1_ORD,
  :MKB2_ORD,
  :MKB1S_ORD,
  :MKB1SS_ORD,
  :CODE_USL_ORD,
  :CODE_MD_ORD,
  :PERSCODE_ORD,
  :MSK_OT_ORD,
  :CODE_MSK_ORD,
  :VID_MP_ORD,
  :USL_OK_ORD,
  :PROFIL_ORD,
  :ISH_MOV_ORD,
  :RES_GOSP_ORD,
  :SPEC_MD_ORD,
  :CODE_LPU_ORD,
  :VID_TR_ORD,
  :DOMC_TYPE_ORD,
  :OKATO_INS_ORD,
  :P_CEL_ORD
from
  sync_data where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
into
  :GKEY,
  :IDSL,
  :MSK_OT,
  :CODE_MSK,
  :VID_MP,
  :USL_OK,
  :PROFIL,
  :MKB1,
  :MKB2,
  :CODE_USL,
  :CODE_MD,
  :KOL_USL,
  :KOL_FACT,
  :ISH_MOV,
  :RES_GOSP,
  :TARIF_B,
  :TARIF_S,
  :TARIF_1K,
  :SUM_RUB,
  :VID_TR,
  :EXTR,
  :SOUF,
  :SPEC_MD,
  :DOMC_TYPE,
  :OKATO_INS,
  :NOVOR,
  :CODE_LPU,
  :VID_SF,
  :PERSCODE,
  :TARIF_D,
  :VID_KOEFF,
  :USL_TMP,
  :SEX,
  :COUNTRY,
  :INV,
  :FOR_POM,
  :MSE,
  :P_CEL,
  :DN,
  :MKB0,
  :DS_ONK,
  :DATE_IN,
  :DATE_OUT,
  :DATE_NPR,
  :BIRTHDAY,
  :BIRTHDAY_P,
  :MKB_SHORT,
  :MKB_SUPERSHORT,
  :DATE_NPR_OF_WEEK,
  :DATE_NPR_MONTH,
  :DATE_NPR_DIF,
  :DATE_IN_OF_WEEK,
  :DATE_IN_MONTH,
  :DATE_OUT_OF_WEEK,
  :DATE_OUT_MONTH,
  :DATE_DIFF,
  :OLD_VAR,
  :Sum_per_Day,
  :KOL_USL_per_Day,
  :KOL_FACT_per_Day,
  :DATE_NPR_DIF_RATE,
  :KOL_USLKOL_FACT,
  :TARIF_BTARIF_D,
  :TARIF_BSUM_RUB,
  :KOL_USLKOL_FACT_P,
  :TARIF_BSUM_RUB_P,
  :KOL_USL_RATE,
  :KOL_FACT_RATE,
  :DIF_OT,
  :KOL_DEF,
  :aggr_lpu_KOL_DEF,
  :aggr_lpu_COUNT,
  :aggr_lpu_RATE,
  :aggr_MSK_OT_KOL_DEF,
  :aggr_MSK_OT_COUNT,
  :aggr_MSK_OT_RATE,
  :IS_EKMP,
  :VID_PROV,
  :MKB0_ORD,
  :MKB1_ORD,
  :MKB2_ORD,
  :MKB1S_ORD,
  :MKB1SS_ORD,
  :CODE_USL_ORD,
  :CODE_MD_ORD,
  :PERSCODE_ORD,
  :MSK_OT_ORD,
  :CODE_MSK_ORD,
  :VID_MP_ORD,
  :USL_OK_ORD,
  :PROFIL_ORD,
  :ISH_MOV_ORD,
  :RES_GOSP_ORD,
  :SPEC_MD_ORD,
  :CODE_LPU_ORD,
  :VID_TR_ORD,
  :DOMC_TYPE_ORD,
  :OKATO_INS_ORD,
  :P_CEL_ORD
do
begin
  if (MSK_OT is null ) then MSK_OT = 'zero'; else MSK_OT = MSK_OT;

  if (CODE_MSK is null ) then CODE_MSK = 'zero'; else CODE_MSK = CODE_MSK;

  if (VID_MP is null ) then VID_MP = 'zero'; else VID_MP = VID_MP;

  if (USL_OK is null ) then USL_OK = 'zero'; else USL_OK = USL_OK;

  if (PROFIL is null ) then PROFIL = 'zero'; else PROFIL = PROFIL;

  if (MKB1 is null ) then MKB1 = 'zero'; else MKB1 = MKB1;

  if (MKB2 is null ) then MKB2 = 'zero'; else MKB2 = MKB2;

  if (CODE_USL is null ) then CODE_USL = 'zero'; else CODE_USL = CODE_USL;

  if (CODE_MD is null ) then CODE_MD = 'zero'; else CODE_MD = CODE_MD;

  if (KOL_USL is null ) then KOL_USL = 0; else KOL_USL = KOL_USL;

  if (KOL_FACT is null ) then KOL_FACT = 0; else KOL_FACT = KOL_FACT;

  if (ISH_MOV is null ) then ISH_MOV = 'zero'; else ISH_MOV = ISH_MOV;

  if (RES_GOSP is null ) then RES_GOSP = 'zero'; else RES_GOSP = RES_GOSP;

  if (TARIF_B is null ) then TARIF_B = 0; else TARIF_B = TARIF_B;

  if (TARIF_S is null ) then TARIF_S = 0; else TARIF_S = TARIF_S;

  if (TARIF_1K is null ) then TARIF_1K = 0; else TARIF_1K = TARIF_1K;

  if (SUM_RUB is null ) then SUM_RUB = 0; else SUM_RUB = SUM_RUB;

  if (VID_TR is null ) then VID_TR = 'zero'; else VID_TR = VID_TR;

  if (EXTR is null ) then EXTR = 'zero'; else EXTR = EXTR;

  if (SOUF is null ) then SOUF = 0; else SOUF = SOUF;

  if (SPEC_MD is null ) then SPEC_MD = 'zero'; else SPEC_MD = SPEC_MD;

  if (DOMC_TYPE is null ) then DOMC_TYPE = 'zero'; else DOMC_TYPE = DOMC_TYPE;

  if (OKATO_INS is null ) then OKATO_INS = 'zero'; else OKATO_INS = OKATO_INS;

  if (NOVOR is null ) then NOVOR = 0; else NOVOR = NOVOR;

  if (CODE_LPU is null ) then CODE_LPU = 'zero'; else CODE_LPU = CODE_LPU;

  if (VID_SF is null ) then VID_SF = 0; else VID_SF = VID_SF;

  if (PERSCODE is null ) then PERSCODE = 'zero'; else PERSCODE = PERSCODE;

  if (TARIF_D is null ) then TARIF_D = 0; else TARIF_D = TARIF_D;

  if (VID_KOEFF is null ) then VID_KOEFF = 0; else VID_KOEFF = VID_KOEFF;

  if (USL_TMP is null ) then USL_TMP = 0; else USL_TMP = USL_TMP;

  if (SEX is null ) then SEX = 0; else SEX = SEX;

  if (COUNTRY is null ) then COUNTRY = 0; else COUNTRY = COUNTRY;

  if (INV is null ) then INV = 0; else INV = INV;

  if (FOR_POM is null ) then FOR_POM = 0; else FOR_POM = FOR_POM;

  if (MSE is null ) then MSE = 0; else MSE = MSE;

  if (P_CEL is null ) then P_CEL = 'zero'; else P_CEL = P_CEL;

  if (DN is null ) then DN = 'zero'; else DN = DN;

  if (MKB0 is null ) then MKB0 = 'zero'; else MKB0 = MKB0;

  :MKB0_VAR = MKB0;
  :MKB1_VAR = MKB1;
  :MKB2_VAR = MKB2;

  :MKB1_S_VAR = MKB_SHORT;
  :MKB1_SS_VAR = MKB_SUPERSHORT;

  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB0' and md.val = :MKB0_VAR into :MKB0_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB1' and md.val = :MKB1_VAR into :MKB1_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB2' and md.val = :MKB2_VAR into :MKB2_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB1_SHORT' and md.val = :MKB1_S_VAR into :MKB1S_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB1_SUPERSHORT' and md.val = :MKB1_SS_VAR into :MKB1SS_ORD;

  :CODE_USL_VAR = :CODE_USL;
  :CODE_MD_VAR = :CODE_MD;

  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_USL' and md.val = :CODE_USL_VAR into :CODE_USL_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_MD' and md.val = :CODE_MD_VAR into :CODE_MD_ORD;

  :PERSCODE_VAR = :PERSCODE;

  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'PERSCODE' and md.val = :PERSCODE_VAR into :PERSCODE_ORD;

  :CODE_LPU_VAR = :CODE_LPU;

  select CNT, DEF FROM model_aggr mla where mla.model_id = :MODEL_ID_VAR and mla.KIND = :MODEL_TYPE and mla.var = 'CODE_LPU' and mla.val = :CODE_LPU_VAR into :aggr_lpu_COUNT, :aggr_lpu_KOL_DEF;
  :aggr_lpu_RATE = (:aggr_lpu_KOL_DEF + 1) / (:aggr_lpu_COUNT + 10);

  :MSK_OT_VAR = :MSK_OT;
  :CODE_MSK_VAR = :CODE_MSK;
  :VID_MP_VAR = :VID_MP;
  :USL_OK_VAR = :USL_OK;
  :PROFIL_VAR = :PROFIL;
  :ISH_MOV_VAR = :ISH_MOV;
  :RES_GOSP_VAR = :RES_GOSP;
  :SPEC_MD_VAR = :SPEC_MD;
  :VID_TR_VAR = :VID_TR;
  :DOMC_TYPE_VAR = :DOMC_TYPE;
  :OKATO_INS_VAR = :OKATO_INS;
  :EXTR_VAR = :EXTR;
  :DN_VAR = :DN;
  :P_CEL_VAR = :P_CEL;

  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'MSK_OT' and md.val = :MSK_OT_VAR into :MSK_OT_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_MSK' and md.val = :CODE_MSK_VAR into :CODE_MSK_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'VID_MP' and md.val = :VID_MP_VAR into :VID_MP_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'USL_OK' and md.val = :USL_OK_VAR into :USL_OK_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'PROFIL' and md.val = :PROFIL_VAR into :PROFIL_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'ISH_MOV' and md.val = :ISH_MOV_VAR into :ISH_MOV_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'RES_GOSP' and md.val = :RES_GOSP_VAR into :RES_GOSP_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'SPEC_MD' and md.val = :SPEC_MD_VAR into :SPEC_MD_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_LPU' and md.val = :CODE_LPU_VAR into :CODE_LPU_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'VID_TR' and md.val = :VID_TR_VAR into :VID_TR_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'DOMC_TYPE' and md.val = :DOMC_TYPE_VAR into :DOMC_TYPE_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'OKATO_INS' and md.val = :OKATO_INS_VAR into :OKATO_INS_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'EXTR' and md.val = :EXTR_VAR into :EXTR_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'DN' and md.val = :DN_VAR into :DN_ORD;
  select ORD FROM model_dictionary md where md.model_id = :MODEL_ID_VAR and md.var = 'P_CEL' and md.val = :P_CEL_VAR into :P_CEL_ORD;

  select CNT, DEF FROM model_aggr mmoa where mmoa.model_id = :MODEL_ID_VAR and mmoa.KIND = :MODEL_TYPE and mmoa.var = 'MSK_OT' and mmoa.val = :MSK_OT_VAR into :AGGR_MSK_OT_COUNT, :AGGR_MSK_OT_KOL_DEF;
  :aggr_MSK_OT_RATE = (aggr_MSK_OT_KOL_DEF + 1) / cast((AGGR_MSK_OT_COUNT + 10) as float);

  if (DS_ONK is null ) then DS_ONK = 0; else DS_ONK = DS_ONK;

  if (DATE_IN is null )
  then
  begin
    DATE_IN = DATE_IN_MED;
    DATE_IN_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_IN_MED);
    DATE_IN_MONTH = EXTRACT(DAY FROM DATE_IN_MED);
  end
  else
  begin
    DATE_IN = DATE_IN;
    DATE_IN_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_IN);
    DATE_IN_MONTH = EXTRACT(DAY FROM DATE_IN);
  end

  DATE_IN_VAR = DATE_IN;

  if (DATE_OUT is null )
  then
  begin
    DATE_OUT = DATE_OUT_MED;
    DATE_OUT_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_OUT_MED);
    DATE_OUT_MONTH = EXTRACT(DAY FROM DATE_OUT_MED);
  end
  else
  begin
    DATE_OUT = DATE_OUT;
    DATE_OUT_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_OUT);
    DATE_OUT_MONTH = EXTRACT(DAY FROM DATE_OUT);
  end

  DATE_OUT_VAR = DATE_OUT;

  if (DATE_NPR is null )
  then
  begin
    DATE_NPR = DATE_NPR_MED;
    DATE_NPR_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_NPR_MED);
    DATE_NPR_MONTH = EXTRACT(DAY FROM DATE_NPR_MED);
  end
  else
  begin
    DATE_NPR = DATE_NPR;
    DATE_NPR_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_NPR);
    DATE_NPR_MONTH = EXTRACT(DAY FROM DATE_NPR);
  end

  DATE_NPR_VAR = DATE_NPR;

  DATE_NPR_DIF = datediff (day, DATE_NPR_VAR, DATE_IN_VAR) + 1/cast(6 as float);

  DATE_DIFF = cast( datediff (day, DATE_OUT_VAR, DATE_IN_VAR) as float) + 1/cast(6 as float);

  if (BIRTHDAY is null ) then BIRTHDAY = BIRTHDAY_MED; else BIRTHDAY = BIRTHDAY;

  BIRTHDAY_VAR = BIRTHDAY;

  if (BIRTHDAY_P is null ) then BIRTHDAY_P = BIRTHDAY_P_MED; else BIRTHDAY_P = BIRTHDAY_P;

  OLD_VAR =  cast( datediff (year, DATE_IN_VAR, BIRTHDAY_VAR) as float);

  Sum_per_Day = SUM_RUB / cast(DATE_DIFF as float);

  KOL_USL_per_Day =   KOL_USL /  cast(DATE_DIFF as float);

  KOL_FACT_per_Day = KOL_FACT / cast(DATE_DIFF as float);

  DATE_NPR_DIF_RATE = DATE_NPR_DIF / cast(DATE_DIFF as float);

  KOL_USLKOL_FACT = KOL_USL - KOL_FACT;
  TARIF_BTARIF_D = TARIF_B- TARIF_D;
  TARIF_BSUM_RUB = TARIF_B - SUM_RUB;
  KOL_USLKOL_FACT_p = KOL_USL + KOL_FACT;
  TARIF_BSUM_RUB_p = TARIF_B + SUM_RUB;
  KOL_USL_rate = SUM_RUB / ( KOL_USL + 0.01);
  KOL_FACT_rate = SUM_RUB / ( KOL_FACT + 0.01);

  if (NOVOR = 0)
  then       
     NOVOR = 0;
  else
     NOVOR = 1;

  if (SEX = 2)
  then
     SEX = 1;
  else
     SEX = 0;

  if (MSK_OT <> CODE_MSK)
  then
     DIF_OT = 1;
  else
     DIF_OT = 0;

  IS_EKMP = 0;

  suspend;
end

end
^

ALTER PROCEDURE GET_RECORDS_COUNT(
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MEE SMALLINT,
  EKMP SMALLINT)
RETURNS (
  REC_COUNT INTEGER)
AS
begin

  select count(*) as REC_COUNT from sync_data where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE or EKMP >= :EKMP) into :REC_COUNT;
  suspend;

end
^

ALTER PROCEDURE MAKE_AGGR(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
AS
declare variable MEE_VAL smallint;
declare variable EKMP_VAL smallint;
begin

if (:model_type = 0) then
begin
  :MEE_VAL = 0;
  :EKMP_VAL = 2;
end
else
begin
  :MEE_VAL = 2;
  :EKMP_VAL = 0;
end

MERGE INTO model_aggr mla
USING
(
  select
    :model_id as MODEL_ID,
    :MODEL_TYPE as KIND,
    'CODE_LPU' as VAR,
    t.CODE_LPU_VAL as CODE_LPU_VAL,
    t.CNT as CNT,
    case
      when :MODEL_TYPE = 0 then MEE_DEF
      when :MODEL_TYPE = 1 then EKMP_DEF
    else 0
    end as DEF
  from
  (
    select
      CODE_LPU as CODE_LPU_VAL,
      count(*) as CNT,
      sum(mee) as MEE_DEF,
      sum(ekmp) as EKMP_DEF
    from
      sync_data where CODE_LPU is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
    group by
      CODE_LPU
  ) t
) items  ON

( mla.model_id = items.MODEL_ID and mla.kind = items.kind and mla.var = items.var and mla.val = items.CODE_LPU_VAL )

  WHEN MATCHED THEN UPDATE SET
    mla.MODEL_ID = items.MODEL_ID,
    mla.KIND = items.KIND,
    mla.VAR = items.VAR,
    mla.VAL = items.CODE_LPU_VAL,
    mla.CNT = items.CNT,
    mla.DEF = items.DEF

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    KIND,
    VAR,
    VAL,
    CNT,
    DEF
  )
  VALUES
  (
    items.MODEL_ID,
    items.KIND,
    items.VAR,
    items.CODE_LPU_VAL,
    items.CNT,
    items.DEF
  );

MERGE INTO model_aggr mmoa
USING
(
  select
    :model_id as MODEL_ID,
    :MODEL_TYPE as KIND,
    'MSK_OT' as VAR,
    t.MSK_OT_VAL as MSK_OT_VAL,
    t.CNT as CNT,
    case
      when :MODEL_TYPE = 0 then MEE_DEF
      when :MODEL_TYPE = 1 then EKMP_DEF
    else 0
    end as DEF
  from
  (
    select
      MSK_OT as MSK_OT_VAL,
      count(*) as CNT,
      sum(mee) as MEE_DEF,
      sum(ekmp) as EKMP_DEF
    from
      sync_data where MSK_OT is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
    group by
      MSK_OT
  ) t
) items  ON

( mmoa.model_id = items.MODEL_ID AND mmoa.kind = items.kind AND mmoa.var = items.var and mmoa.val = items.MSK_OT_VAL )

  WHEN MATCHED THEN UPDATE SET
    mmoa.MODEL_ID  = items.MODEL_ID,
    mmoa.KIND = items.KIND,
    mmoa.VAR = items.VAR,
    mmoa.VAL = items.MSK_OT_VAL,
    mmoa.CNT = items.CNT,
    mmoa.DEF = items.DEF

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    KIND,
    VAR,
    VAL,
    CNT,
    DEF
  )
  VALUES
  (
    items.MODEL_ID,
    items.KIND,
    items.VAR,
    items.MSK_OT_VAL,
    items.CNT,
    items.DEF
  );

end
^

ALTER PROCEDURE MAKE_AGGR_TMP(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
AS
declare variable MEE_VAL smallint;
declare variable EKMP_VAL smallint;
begin

if (:model_type = 0) then
begin
  :MEE_VAL = 0;
  :EKMP_VAL = 2;
end
else
begin
  :MEE_VAL = 2;
  :EKMP_VAL = 0;
end

MERGE INTO model_aggr_tmp mla
USING
(
  select
    :model_id as MODEL_ID,
    :MODEL_TYPE as KIND,
    'CODE_LPU' as VAR,
    t.CODE_LPU_VAL as CODE_LPU_VAL,
    t.CNT as CNT,
    case
      when :MODEL_TYPE = 0 then MEE_DEF
      when :MODEL_TYPE = 1 then EKMP_DEF
    else 0
    end as DEF
  from
  (
    select
      CODE_LPU as CODE_LPU_VAL,
      count(*) as CNT,
      sum(mee) as MEE_DEF,
      sum(ekmp) as EKMP_DEF
    from
      sync_data where CODE_LPU is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
    group by
      CODE_LPU
  ) t
) items  ON

( mla.model_id = items.MODEL_ID and mla.kind = items.kind and mla.var = items.var and mla.val = items.CODE_LPU_VAL )

  WHEN MATCHED THEN UPDATE SET
    mla.MODEL_ID = items.MODEL_ID,
    mla.KIND = items.KIND,
    mla.VAR = items.VAR,
    mla.VAL = items.CODE_LPU_VAL,
    mla.CNT = items.CNT,
    mla.DEF = items.DEF

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    KIND,
    VAR,
    VAL,
    CNT,
    DEF
  )
  VALUES
  (
    items.MODEL_ID,
    items.KIND,
    items.VAR,
    items.CODE_LPU_VAL,
    items.CNT,
    items.DEF
  );

MERGE INTO model_aggr_tmp mmoa
USING
(
  select
    :model_id as MODEL_ID,
    :MODEL_TYPE as KIND,
    'MSK_OT' as VAR,
    t.MSK_OT_VAL as MSK_OT_VAL,
    t.CNT as CNT,
    case
      when :MODEL_TYPE = 0 then MEE_DEF
      when :MODEL_TYPE = 1 then EKMP_DEF
    else 0
    end as DEF
  from
  (
    select
      MSK_OT as MSK_OT_VAL,
      count(*) as CNT,
      sum(mee) as MEE_DEF,
      sum(ekmp) as EKMP_DEF
    from
      sync_data where MSK_OT is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
    group by
      MSK_OT
  ) t
) items  ON

( mmoa.model_id = items.MODEL_ID AND mmoa.kind = items.kind AND mmoa.var = items.var and mmoa.val = items.MSK_OT_VAL )

  WHEN MATCHED THEN UPDATE SET
    mmoa.MODEL_ID  = items.MODEL_ID,
    mmoa.KIND = items.KIND,
    mmoa.VAR = items.VAR,
    mmoa.VAL = items.MSK_OT_VAL,
    mmoa.CNT = items.CNT,
    mmoa.DEF = items.DEF

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    KIND,
    VAR,
    VAL,
    CNT,
    DEF
  )
  VALUES
  (
    items.MODEL_ID,
    items.KIND,
    items.VAR,
    items.MSK_OT_VAL,
    items.CNT,
    items.DEF
  );

end
^

ALTER PROCEDURE MAKE_DICTIONARY(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE)
AS
begin

MERGE INTO model_dictionary dict

  USING
  (
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'PERSCODE' as VAR, PERSCODE as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and PERSCODE is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1_SHORT' as VAR, SUBSTRING(MKB1 FROM 1 FOR 4) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB1 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1_SUPERSHORT' as VAR, SUBSTRING(MKB1 FROM 1 FOR 1) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB1 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL)) as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB0' as VAR, SUBSTRING(MKB0 FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB0 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1' as VAR, cast(MKB1 as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB1 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL)) as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB2' as VAR, cast(MKB2 as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB2 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB3' as VAR, cast(MKB3 as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB3 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_USL' as VAR, cast(CODE_USL as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and CODE_USL is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_MD' as VAR, cast(CODE_MD as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and CODE_MD is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MSK_OT' as VAR, cast(MSK_OT as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MSK_OT is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_MSK' as VAR, cast(CODE_MSK as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and CODE_MSK is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'VID_MP' as VAR, cast(VID_MP as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and VID_MP is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'USL_OK' as VAR, cast(USL_OK as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and USL_OK is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'PROFIL' as VAR, cast(PROFIL as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and PROFIL is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'ISH_MOV' as VAR, cast(ISH_MOV as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and ISH_MOV is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'RES_GOSP' as VAR, cast(RES_GOSP as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and RES_GOSP is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'SPEC_MD' as VAR, cast(SPEC_MD as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and SPEC_MD is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_LPU' as VAR, cast(CODE_LPU as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and CODE_LPU is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'VID_TR' as VAR, cast(VID_TR as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and VID_TR is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'DOMC_TYPE' as VAR, cast(DOMC_TYPE as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and DOMC_TYPE is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'OKATO_INS' as VAR, cast(OKATO_INS as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and OKATO_INS is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'EXTR' as VAR, cast(EXTR as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and EXTR is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'DN' as VAR, cast(DN as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and DN is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'P_CEL' as VAR, cast(P_CEL as varchar(20)) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and P_CEL is not null and (MEE >= 0 or EKMP >= 0)
    ) D
  ) items  ON

  ( dict.MODEL_ID = :model_id and dict.VAR = items.VAR and dict.VAL = items.VAL )

  WHEN MATCHED THEN UPDATE SET
    dict.model_id = items.MODEL_ID,
    dict.VAR = items.VAR,
    dict.VAL = items.VAL,
    dict.ORD = items.ORD

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    VAR,
    VAL,
    ORD
  )
  VALUES
  (
    items.MODEL_ID,
    items.VAR,
    items.VAL,
    items.ORD
  );

MERGE INTO model_dictionary dict

  USING
  (
    select ( :model_id ) as MODEL_ID, 'PERSCODE' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'PERS_CODE' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MKB1_SHORT' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'MKB1_SHORT' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MKB1_SUPERSHORT' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'MKB1_SUPERSHORT' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MKB0' as VAR, 'zero' as VAL, 0 as ORD from RDB$DATABASE
    UNION                                                                                                                                                                
    select ( :model_id ) as MODEL_ID, 'MKB1' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'MKB1' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MKB2' as VAR, 'zero' as VAL, 0 as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MKB3' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'MKB3' and val <> 'zero') as ORD from RDB$DATABASE
    UNION                                                 
    select ( :model_id ) as MODEL_ID, 'CODE_USL' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'CODE_USL' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'CODE_MD' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'CODE_MD' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MSK_OT' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'MSK_OT' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'CODE_MSK' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'CODE_MSK' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'VID_MP' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'VID_MP' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'USL_OK' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'USL_OK' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'PROFIL' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'PROFIL' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'ISH_MOV' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'ISH_MOV' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'RES_GOSP' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'RES_GOSP' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'SPEC_MD' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'SPEC_MD' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'CODE_LPU' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'CODE_LPU' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'VID_TR' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'VID_TR' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'DOMC_TYPE' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'DOMC_TYPE' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'OKATO_INS' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'OKATO_INS' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'EXTR' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'EXTR' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'DN' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'DN' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'P_CEL' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'P_CEL' and val <> 'zero') as ORD from RDB$DATABASE
  ) items  ON

  ( dict.MODEL_ID = :model_id and dict.VAR = items.VAR and dict.VAL = items.VAL )

  WHEN MATCHED THEN UPDATE SET
    dict.model_id = items.MODEL_ID,
    dict.VAR = items.VAR,
    dict.VAL = items.VAL,
    dict.ORD = items.ORD

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    VAR,
    VAL,
    ORD
  )
  VALUES
  (
    items.MODEL_ID,
    items.VAR,
    items.VAL,
    items.ORD
  );

end
^

ALTER PROCEDURE MAKE_DICTIONARY_MOST_FREQ(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE)
AS
begin

  MERGE INTO model_dictionary_most_freq dict

  USING
  (
    SELECT ( :model_id ) as MODEL_ID, 'PERSCODE' as VAR,
    (
      select
        case
          when
          (
            select count(*) as PERSCODE from sync_data where PERSCODE is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select PERSCODE from
            (
              select first 1 PERSCODE, count(*) as freq
              from ( select PERSCODE from(select PERSCODE from sync_data where PERSCODE is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.PERSCODE order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'MKB0' as VAR,
    (
      select
        case
          when
          (
            select count(*) as MKB0 from sync_data where MKB0 is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select MKB0 from
            (
              select first 1 MKB0, count(*) as freq
              from ( select MKB0 from(select MKB0 from sync_data where MKB0 is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.MKB0 order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'MKB1' as VAR,
    (
      select
        case
          when
          (
            select count(*) as MKB1 from sync_data where MKB1 is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select MKB1 from
            (
              select first 1 MKB1, count(*) as freq
              from ( select MKB1 from(select MKB1 from sync_data where MKB1 is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.MKB1 order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'MKB2' as VAR,
    (
      select
        case
          when
          (
            select count(*) as MKB2 from sync_data where MKB2 is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select MKB2 from
            (
              select first 1 MKB2, count(*) as freq
              from ( select MKB2 from(select MKB2 from sync_data where MKB2 is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.MKB2 order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'MKB3' as VAR,
    (
      select
        case
          when
          (
            select count(*) as MKB3 from sync_data where MKB3 is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select MKB3 from
            (
              select first 1 MKB3, count(*) as freq
              from ( select MKB3 from(select MKB3 from sync_data where MKB3 is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.MKB3 order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'CODE_USL' as VAR,
    (
      select
        case
          when
          (
            select count(*) as CODE_USL from sync_data where CODE_USL is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select CODE_USL from
            (
              select first 1 CODE_USL, count(*) as freq
              from ( select CODE_USL from(select CODE_USL from sync_data where CODE_USL is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.CODE_USL order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'CODE_MD' as VAR,
    (
      select
        case
          when
          (
            select count(*) as CODE_MD from sync_data where CODE_MD is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select CODE_MD from
            (
              select first 1 CODE_MD, count(*) as freq
              from ( select CODE_MD from(select CODE_MD from sync_data where CODE_MD is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.CODE_MD order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'MSK_OT' as VAR,
    (
      select
        case
          when
          (
            select count(*) as MSK_OT from sync_data where MSK_OT is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select MSK_OT from
            (
              select first 1 MSK_OT, count(*) as freq
              from ( select MSK_OT from(select MSK_OT from sync_data where MSK_OT is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.MSK_OT order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'CODE_MSK' as VAR,
    (
      select
        case
          when
          (
            select count(*) as CODE_MSK from sync_data where CODE_MSK is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select CODE_MSK from
            (
              select first 1 CODE_MSK, count(*) as freq
              from ( select CODE_MSK from(select CODE_MSK from sync_data where CODE_MSK is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.CODE_MSK order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'VID_MP' as VAR,
    (
      select
        case
          when
          (
            select count(*) as VID_MP from sync_data where VID_MP is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select VID_MP from
            (
              select first 1 VID_MP, count(*) as freq
              from ( select VID_MP from(select VID_MP from sync_data where VID_MP is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.VID_MP order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'USL_OK' as VAR,
    (
      select
        case
          when
          (
            select count(*) as USL_OK from sync_data where USL_OK is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select USL_OK from
            (
              select first 1 USL_OK, count(*) as freq
              from ( select USL_OK from(select USL_OK from sync_data where USL_OK is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.USL_OK order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'PROFIL' as VAR,
    (
      select
        case
          when
          (
            select count(*) as PROFIL from sync_data where PROFIL is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select PROFIL from
            (
              select first 1 PROFIL, count(*) as freq
              from ( select PROFIL from(select PROFIL from sync_data where PROFIL is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.PROFIL order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'ISH_MOV' as VAR,
    (
      select
        case
          when
          (
            select count(*) as ISH_MOV from sync_data where ISH_MOV is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select ISH_MOV from
            (
              select first 1 ISH_MOV, count(*) as freq
              from ( select ISH_MOV from(select ISH_MOV from sync_data where ISH_MOV is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.ISH_MOV order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'RES_GOSP' as VAR,
    (
      select
        case
          when
          (
            select count(*) as RES_GOSP from sync_data where RES_GOSP is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select RES_GOSP from
            (
              select first 1 RES_GOSP, count(*) as freq
              from ( select RES_GOSP from(select RES_GOSP from sync_data where RES_GOSP is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.RES_GOSP order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'CODE_LPU' as VAR,
    (
      select
        case
          when
          (
            select count(*) as CODE_LPU from sync_data where CODE_LPU is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select CODE_LPU from
            (
              select first 1 CODE_LPU, count(*) as freq
              from ( select CODE_LPU from(select CODE_LPU from sync_data where CODE_LPU is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.CODE_LPU order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'VID_TR' as VAR,
    (
      select
        case
          when
          (
            select count(*) as VID_TR from sync_data where VID_TR is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select VID_TR from
            (
              select first 1 VID_TR, count(*) as freq
              from ( select VID_TR from(select VID_TR from sync_data where VID_TR is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.VID_TR order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'DOMC_TYPE' as VAR,
    (
      select
        case
          when
          (
            select count(*) as DOMC_TYPE from sync_data where DOMC_TYPE is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select DOMC_TYPE from
            (
              select first 1 DOMC_TYPE, count(*) as freq
              from ( select DOMC_TYPE from(select DOMC_TYPE from sync_data where DOMC_TYPE is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.DOMC_TYPE order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'OKATO_INS' as VAR,
    (
      select
        case
          when
          (
            select count(*) as OKATO_INS from sync_data where OKATO_INS is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select OKATO_INS from
            (
              select first 1 OKATO_INS, count(*) as freq
              from ( select OKATO_INS from(select OKATO_INS from sync_data where OKATO_INS is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.OKATO_INS order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'EXTR' as VAR,
    (
      select
        case
          when
          (
            select count(*) as EXTR from sync_data where EXTR is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select EXTR from
            (
              select first 1 EXTR, count(*) as freq
              from ( select EXTR from(select EXTR from sync_data where EXTR is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.EXTR order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'DN' as VAR,
    (
      select
        case
          when
          (
            select count(*) as DN from sync_data where DN is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select DN from
            (
              select first 1 DN, count(*) as freq
              from ( select DN from(select DN from sync_data where DN is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.DN order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
    UNION
    SELECT ( :model_id ) as MODEL_ID, 'P_CEL' as VAR,
    (
      select
        case
          when
          (
            select count(*) as P_CEL from sync_data where P_CEL is not null and DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
          ) = 0 then 'zero'
          else
          (
            select P_CEL from
            (
              select first 1 P_CEL, count(*) as freq
              from ( select P_CEL from(select P_CEL from sync_data where P_CEL is not null and DATE_OT_PER  >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0))) t
              group by t.P_CEL order by freq desc
            )
          )
        end AS VAL
      from
        RDB$DATABASE
    ) AS VAL from RDB$DATABASE
) items  ON

  ( dict.MODEL_ID = :model_id and dict.VAR = items.VAR )

  WHEN MATCHED THEN UPDATE SET
    dict.model_id = items.MODEL_ID,
    dict.VAR = items.VAR

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    VAR,
    VAL
  )
  VALUES
  (
    items.MODEL_ID,
    items.VAR,
    items.VAL
  );

end
^

ALTER PROCEDURE MAKE_DICTIONARY_TMP(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE)
AS
begin

MERGE INTO model_dictionary_tmp dict

  USING
  (
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = M.MODEL_ID and mdmf.var = 'PERSCODE'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'PERSCODE' as VAR, COALESCE(cast(PERSCODE as varchar(36)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = M.MODEL_ID and mdmf.var = 'MKB1_SHORT'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1_SHORT' as VAR, COALESCE(SUBSTRING(MKB1 FROM 1 FOR 4), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MKB1_SUPERSHORT'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1_SUPERSHORT' as VAR, COALESCE(SUBSTRING(MKB1 FROM 1 FOR 1), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MKB0'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB0' as VAR, COALESCE(cast(MKB0 as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MKB1'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1' as VAR, COALESCE(cast(MKB1 as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MKB2'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB2' as VAR, COALESCE(cast(MKB2 as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MKB3'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB3' as VAR, COALESCE(cast(MKB3 as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'CODE_USL'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_USL' as VAR, COALESCE(cast(CODE_USL as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'CODE_MD'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_MD' as VAR, COALESCE(cast(CODE_MD as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MSK_OT'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MSK_OT' as VAR, COALESCE(cast(MSK_OT as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'CODE_MSK'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_MSK' as VAR, COALESCE(cast(CODE_MSK as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'VID_MP'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'VID_MP' as VAR, COALESCE(cast(VID_MP as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'USL_OK'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'USL_OK' as VAR, COALESCE(cast(USL_OK as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'PROFIL'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'PROFIL' as VAR, COALESCE(cast(PROFIL as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'ISH_MOV'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'ISH_MOV' as VAR, COALESCE(cast(ISH_MOV as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'RES_GOSP'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'RES_GOSP' as VAR, COALESCE(cast(RES_GOSP as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'SPEC_MD'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'SPEC_MD' as VAR, COALESCE(cast(SPEC_MD as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'CODE_LPU'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_LPU' as VAR, COALESCE(cast(CODE_LPU as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'VID_TR'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'VID_TR' as VAR, COALESCE(cast(VID_TR as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'DOMC_TYPE'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'DOMC_TYPE' as VAR, COALESCE(cast(DOMC_TYPE as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'OKATO_INS'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'OKATO_INS' as VAR, COALESCE(cast(OKATO_INS as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'EXTR'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'EXTR' as VAR, COALESCE(cast(EXTR as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'DN'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'DN' as VAR, COALESCE(cast(DN as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'P_CEL'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'P_CEL' as VAR, COALESCE(cast(P_CEL as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= 0 or EKMP >= 0)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
  ) items  ON

  ( dict.MODEL_ID = :model_id and dict.VAR = items.VAR and dict.VAL = items.VAL )

  WHEN MATCHED THEN UPDATE SET
    dict.model_id = items.MODEL_ID,
    dict.VAR = items.VAR,
    dict.VAL = items.VAL,
    dict.ORD = items.ORD

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    VAR,
    VAL,
    ORD
  )
  VALUES
  (
    items.MODEL_ID,
    items.VAR,
    items.VAL,
    items.ORD
  );

end
^

ALTER PROCEDURE MEDIAN_VALUES(
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
RETURNS (
  DATE_IN_RET DATE,
  DATE_OUT_RET DATE,
  BIRTHDAY_RET DATE,
  BIRTHDAY_P_RET DATE,
  DATE_NPR_RET DATE)
AS
declare variable MEE_VAL smallint;
declare variable EKMP_VAL smallint;
begin

if (PERIOD_BEGIN is null or PERIOD_END is null) then BIRTHDAY_RET = null;

if (:model_type = 0) then
begin
  :MEE_VAL = 0;
  :EKMP_VAL = 2;
end
else
begin
  :MEE_VAL = 2;
  :EKMP_VAL = 0;
end

select
  DATE_IN
from
(
  select
  date_in as date_in, row_number() OVER (ORDER BY date_in) as pos
  from
  (
    SELECT
      distinct date_in
    from
      sync_data where (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
    order by
      date_in asc
  ) arr
) main where main.pos =
(
  select
    cast( cast( a.rowCount as float) / 2 as integer) as rowPos
  from
  (
    select count(*) as rowCount
    from
    (
      SELECT
        distinct date_in
      from
        sync_data where (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      order by
        date_in asc
    )
  ) a
)
into
  :DATE_IN_RET;

select
  DATE_OT_PER
from
(
  select
  DATE_OT_PER as DATE_OT_PER, row_number() OVER (ORDER BY DATE_OT_PER) as pos
  from
  (
    SELECT
      distinct DATE_OT_PER
    from
      sync_data where DATE_OT_PER is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= 0 or EKMP >= 0)
    order by
      DATE_OT_PER asc
  ) arr
) main where main.pos =
(
  select
    cast( cast( a.rowCount as float) / 2 as integer) as rowPos
  from
  (
    select count(*) as rowCount
    from
    (
      SELECT
        distinct DATE_OT_PER
      from
        sync_data where DATE_OT_PER is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= 0 or EKMP >= 0)
      order by
        DATE_OT_PER asc
    )
  ) a
)
into
  :DATE_OUT_RET;

select
  birthday
from
(
  select
  birthday as birthday, row_number() OVER (ORDER BY birthday) as pos
  from
  (
    SELECT
      distinct birthday
    from
      sync_data where birthday is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= 0 or EKMP >= 0)
    order by
      birthday asc
  ) arr
) main where main.pos =
(
  select
    cast( cast( a.rowCount as float) / 2 as integer) as rowPos
  from
  (
    select count(*) as rowCount
    from
    (
      SELECT
        distinct birthday
      from
        sync_data where birthday is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= 0 or EKMP >= 0)
      order by
        birthday asc
    )
  ) a
)
into
  :BIRTHDAY_RET;

select
  birthday_p
from
(
  select
  birthday_p as birthday_p, row_number() OVER (ORDER BY birthday_p) as pos
  from
  (
    SELECT
      distinct birthday_p
    from
      sync_data where birthday_p is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= 0 or EKMP >= 0)
    order by
      birthday_p asc
  ) arr
) main where main.pos =
(
  select
    cast( cast( a.rowCount as float) / 2 as integer) as rowPos
  from
  (
    select count(*) as rowCount
    from
    (
      SELECT
        distinct birthday_p
      from
        sync_data where birthday_p is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= 0 or EKMP >= 0)
      order by
        birthday_p asc
    )
  ) a
)
into
  :BIRTHDAY_P_RET;

select
  date_npr
from
(
  select
  date_npr as date_npr, row_number() OVER (ORDER BY date_npr) as pos
  from
  (
    SELECT
      distinct date_npr
    from
      sync_data where date_npr is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= 0 or EKMP >= 0)
    order by
      date_npr asc
  ) arr
) main where main.pos =
(
  select
    cast( cast( a.rowCount as float) / 2 as integer) as rowPos
  from
  (
    select count(*) as rowCount
    from
    (
      SELECT
        distinct date_npr
      from
        sync_data where date_npr is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= 0 or EKMP >= 0)
      order by
        date_npr asc
    )
  ) a
)
into
  :DATE_NPR_RET;

  suspend;

end
^

ALTER PROCEDURE UPDATE_SYNC_DATA
AS
begin

MERGE INTO sync_data sd

USING
(
  select
    GKEY,
    IDSL,
    MAX(TIME_MARK) as TIME_MARK,
    OT_PER,
    MSK_OT,
    CODE_MSK,
    VID_MP,
    USL_OK,
    PROFIL,
    MKB1,
    MKB2,
    MKB3,
    CODE_USL,
    CODE_MD,
    KOL_USL,
    KOL_FACT,
    ISH_MOV,
    RES_GOSP,
    TARIF_B,
    TARIF_S,
    TARIF_1K,
    SUM_RUB,
    VID_TR,
    EXTR,
    CODE_OTD,
    SOUF,
    SPEC_MD,
    DOMC_TYPE,
    OKATO_INS,
    NOVOR,
    CODE_LPU,
    VID_SF,
    NHISTORY,
    PERSCODE,
    DATE_IN,
    DATE_OUT,
    TARIF_D,
    VID_KOEFF,
    USL_TMP,
    BIRTHDAY,
    SEX,
    COUNTRY,
    SEX_P,
    BIRTHDAY_P,
    INV,
    DATE_NPR,
    FOR_POM,
    MSE,
    P_CEL,
    DN,
    TAL_P,
    PROFIL_K,
    NAPR_MO,
    MKB0,
    DS_ONK,
    VAL_KOEFF,
    C_ZAB,
    CODE_NOM1,
    CODE_NOM2,
    CODE_NOM3,
    VAL_TMP,
    TIME_FIX,
    TIME_IN,
    TIME_OUT,
    DATE_FIX,
    KATEG_MD,
    POST_MD,
    VID_PROV,
    EKMP,
    MEE,
    MED_AREA,
    TAL_HMP,
    DATE_HMP,
    MCOD_OUT,
    NOM_NPR,
    SERIES,
    NAME_MSK,
    OKATO_NAS,
    PR_LG,
    MAX(KOL_DEF) as KOL_DEF,
    (cast (substring(ot_per from 1 for 2) || '-' || '01' || '-' || substring(ot_per from 3 for 4) as date)) as date_ot_per
  from
    sync_tmp_data
  group by
    GKEY,
    IDSL,
    OT_PER,
    MSK_OT,
    CODE_MSK,
    VID_MP,
    USL_OK,
    PROFIL,
    MKB1,
    MKB2,
    MKB3,
    CODE_USL,
    CODE_MD,
    KOL_USL,
    KOL_FACT,
    ISH_MOV,
    RES_GOSP,
    TARIF_B,
    TARIF_S,
    TARIF_1K,
    SUM_RUB,
    VID_TR,
    EXTR,
    CODE_OTD,
    SOUF,
    SPEC_MD,
    DOMC_TYPE,
    OKATO_INS,
    NOVOR,
    CODE_LPU,
    VID_SF,
    NHISTORY,
    PERSCODE,
    DATE_IN,
    DATE_OUT,
    TARIF_D,
    VID_KOEFF,
    USL_TMP,
    BIRTHDAY,
    SEX,
    COUNTRY,
    SEX_P,
    BIRTHDAY_P,
    INV,
    DATE_NPR,
    FOR_POM,
    MSE,
    P_CEL,
    DN,
    TAL_P,
    PROFIL_K,
    NAPR_MO,
    MKB0,
    DS_ONK,
    VAL_KOEFF,
    C_ZAB,
    CODE_NOM1,
    CODE_NOM2,
    CODE_NOM3,
    VAL_TMP,
    TIME_FIX,
    TIME_IN,
    TIME_OUT,
    DATE_FIX,
    KATEG_MD,
    POST_MD,
    VID_PROV,
    EKMP,
    MEE,
    MED_AREA,
    TAL_HMP,
    DATE_HMP,
    MCOD_OUT,
    NOM_NPR,
    SERIES,
    NAME_MSK,
    OKATO_NAS,
    PR_LG
  ) std on (sd.gkey = std.gkey )

  WHEN MATCHED THEN UPDATE SET

    sd.GKEY = std.GKEY,
    sd.IDSL = std.IDSL,
    sd.TIME_MARK = std.TIME_MARK,
    sd.OT_PER = std.OT_PER,
    sd.MSK_OT = std.MSK_OT,
    sd.CODE_MSK = std.CODE_MSK,
    sd.VID_MP = std.VID_MP,
    sd.USL_OK = std.USL_OK,
    sd.PROFIL = std.PROFIL,
    sd.MKB1 = std.MKB1,
    sd.MKB2 = std.MKB2,
    sd.MKB3 = std.MKB3,
    sd.CODE_USL = std.CODE_USL,
    sd.CODE_MD = std.CODE_MD,
    sd.KOL_USL = std.KOL_USL,
    sd.KOL_FACT = std.KOL_FACT,
    sd.ISH_MOV = std.ISH_MOV,
    sd.RES_GOSP = std.RES_GOSP,
    sd.TARIF_B = std.TARIF_B,
    sd.TARIF_S = std.TARIF_S,
    sd.TARIF_1K = std.TARIF_1K,
    sd.SUM_RUB = std.SUM_RUB,
    sd.VID_TR = std.VID_TR,
    sd.EXTR = std.EXTR,
    sd.CODE_OTD = std.CODE_OTD,
    sd.SOUF = std.SOUF,
    sd.SPEC_MD = std.SPEC_MD,
    sd.DOMC_TYPE = std.DOMC_TYPE,
    sd.OKATO_INS = std.OKATO_INS,
    sd.NOVOR = std.NOVOR,
    sd.CODE_LPU = std.CODE_LPU,
    sd.VID_SF = std.VID_SF,
    sd.NHISTORY = std.NHISTORY,
    sd.PERSCODE = std.PERSCODE,
    sd.DATE_IN = std.DATE_IN,
    sd.DATE_OUT = std.DATE_OUT,
    sd.TARIF_D = std.TARIF_D,
    sd.VID_KOEFF = std.VID_KOEFF,
    sd.USL_TMP = std.USL_TMP,
    sd.BIRTHDAY = std.BIRTHDAY,
    sd.SEX = std.SEX,
    sd.COUNTRY = std.COUNTRY,
    sd.SEX_P = std.SEX_P,
    sd.BIRTHDAY_P = std.BIRTHDAY_P,
    sd.INV = std.INV,
    sd.DATE_NPR = std.DATE_NPR,
    sd.FOR_POM = std.FOR_POM,
    sd.MSE = std.MSE,
    sd.P_CEL = std.P_CEL,
    sd.DN = std.DN,
    sd.TAL_P = std.TAL_P,
    sd.PROFIL_K = std.PROFIL_K,
    sd.NAPR_MO = std.NAPR_MO,
    sd.MKB0 = std.MKB0 ,
    sd.DS_ONK = std.DS_ONK,
    sd.VAL_KOEFF = std.VAL_KOEFF,
    sd.C_ZAB = std.C_ZAB,
    sd.CODE_NOM1 = std.CODE_NOM1,
    sd.CODE_NOM2 = std.CODE_NOM2,
    sd.CODE_NOM3 = std.CODE_NOM3,
    sd.VAL_TMP = std.VAL_TMP,
    sd.TIME_FIX = std.TIME_FIX,
    sd.TIME_IN = std.TIME_IN,
    sd.TIME_OUT = std.TIME_OUT,
    sd.DATE_FIX = std.DATE_FIX,
    sd.KATEG_MD = std.KATEG_MD,
    sd.POST_MD = std.POST_MD,
    sd.VID_PROV = std.VID_PROV,
    sd.EKMP = std.EKMP,
    sd.MEE = std.MEE,
    sd.MED_AREA = std.MED_AREA,
    sd.TAL_HMP = std.TAL_HMP,
    sd.DATE_HMP = std.DATE_HMP,
    sd.MCOD_OUT = std.MCOD_OUT,
    sd.NOM_NPR = std.NOM_NPR,
    sd.SERIES = std.SERIES,
    sd.NAME_MSK = std.NAME_MSK,
    sd.OKATO_NAS = std.OKATO_NAS,
    sd.PR_LG = std.PR_LG,
    sd.is_ekmp = 0,
    sd.date_ot_per = std.date_ot_per

  WHEN NOT MATCHED THEN INSERT
  (
    GKEY,
    IDSL,
    TIME_MARK,
    OT_PER,
    MSK_OT,
    CODE_MSK,
    VID_MP,
    USL_OK,
    PROFIL,
    MKB1,
    MKB2,
    MKB3,
    CODE_USL,
    CODE_MD,
    KOL_USL,
    KOL_FACT,
    ISH_MOV,
    RES_GOSP,
   TARIF_B,
    TARIF_S,
    TARIF_1K,
    SUM_RUB,
    VID_TR,
    EXTR,
    CODE_OTD,
    SOUF,
    SPEC_MD,
    DOMC_TYPE,
    OKATO_INS,
    NOVOR,
    CODE_LPU,
    VID_SF,
    NHISTORY,
    PERSCODE,
    DATE_IN,
    DATE_OUT,
    TARIF_D,
    VID_KOEFF,
    USL_TMP,
    BIRTHDAY,
    SEX,
    COUNTRY,
    SEX_P,
    BIRTHDAY_P,
    INV,
    DATE_NPR,
    FOR_POM,
    MSE,
    P_CEL,
    DN,
    TAL_P,
    PROFIL_K,
    NAPR_MO,
    MKB0,
    DS_ONK,
    VAL_KOEFF,
    C_ZAB,
    CODE_NOM1,
    CODE_NOM2,
    CODE_NOM3,
    VAL_TMP,
    TIME_FIX,
    TIME_IN,
    TIME_OUT,
    DATE_FIX,
    KATEG_MD,
    POST_MD,
    KOL_DEF,
    VID_PROV,
    EKMP,
    MEE,
    MED_AREA,
    TAL_HMP,
    DATE_HMP,
    MCOD_OUT,
    NOM_NPR,
    SERIES,
    NAME_MSK,
    OKATO_NAS,
    PR_LG,
    IS_EKMP,
    DATE_OT_PER
  )
  VALUES
  (
    std.GKEY,
    std.IDSL,
    std.TIME_MARK,
    std.OT_PER, 
    std.MSK_OT, 
    std.CODE_MSK, 
    std.VID_MP, 
    std.USL_OK, 
    std.PROFIL, 
    std.MKB1, 
    std.MKB2, 
    std.MKB3, 
    std.CODE_USL, 
    std.CODE_MD , 
    std.KOL_USL , 
    std.KOL_FACT, 
    std.ISH_MOV , 
    std.RES_GOSP, 
    std.TARIF_B , 
    std.TARIF_S , 
    std.TARIF_1K, 
    std.SUM_RUB , 
    std.VID_TR, 
    std.EXTR, 
    std.CODE_OTD, 
    std.SOUF, 
    std.SPEC_MD , 
    std.DOMC_TYPE , 
    std.OKATO_INS , 
    std.NOVOR , 
    std.CODE_LPU, 
    std.VID_SF, 
    std.NHISTORY, 
    std.PERSCODE, 
    std.DATE_IN , 
    std.DATE_OUT, 
    std.TARIF_D , 
    std.VID_KOEFF , 
    std.USL_TMP , 
    std.BIRTHDAY, 
    std.SEX , 
    std.COUNTRY , 
    std.SEX_P , 
    std.BIRTHDAY_P, 
    std.INV , 
    std.DATE_NPR, 
    std.FOR_POM , 
    std.MSE , 
    std.P_CEL , 
    std.DN, 
    std.TAL_P , 
    std.PROFIL_K, 
    std.NAPR_MO , 
    std.MKB0, 
    std.DS_ONK, 
    std.VAL_KOEFF , 
    std.C_ZAB , 
    std.CODE_NOM1 , 
    std.CODE_NOM2 , 
    std.CODE_NOM3 , 
    std.VAL_TMP , 
    std.TIME_FIX, 
    std.TIME_IN , 
    std.TIME_OUT, 
    std.DATE_FIX, 
    std.KATEG_MD, 
    std.POST_MD , 
    (
      case
        when cast(std.KOL_DEF  as float) > 0
         then 1
         else 0
        end
    ),
    std.VID_PROV,
    std.EKMP,
    std.MEE,
    std.MED_AREA,
    std.TAL_HMP,
    std.DATE_HMP,
    std.MCOD_OUT,
    std.NOM_NPR,
    std.SERIES,
    std.NAME_MSK,
    std.OKATO_NAS,
    std.PR_LG,
    0,
    std.date_ot_per
  );

end
^

ALTER PROCEDURE VERSION
RETURNS (
  DB_VERSION INTEGER)
AS
begin
  :DB_VERSION = 4;
  suspend;
end
^

SET TERM ; ^

update sync_data set date_ot_per = cast (substring(ot_per from 1 for 2) || '-' || '01' || '-' || substring(ot_per from 3 for 4) as date);

ALTER TABLE SYNC_DATA ALTER COLUMN MKB2
  TYPE VARCHAR(250) CHARACTER SET UTF8;

ALTER TABLE SYNC_DATA ALTER COLUMN MKB3
  TYPE VARCHAR(250) CHARACTER SET UTF8;

ALTER TABLE SYNC_DATA ALTER COLUMN NHISTORY
  TYPE VARCHAR(50) CHARACTER SET UTF8;

