/*
  Скрипт модернизации Базы Данных от версии 5 к версии 6.
*/

SET TERM ^ ;

ALTER PROCEDURE MAKE_DICTIONARY(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE)
AS
begin

MERGE INTO model_dictionary dict

  USING
  (
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'PERSCODE' as VAR, SUBSTRING(PERSCODE FROM 1 FOR 36) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and PERSCODE is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1_SHORT' as VAR, SUBSTRING(MKB1 FROM 1 FOR 4) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB1 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1_SUPERSHORT' as VAR, SUBSTRING(MKB1 FROM 1 FOR 1) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB1 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL)) as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB0' as VAR, SUBSTRING(MKB0 FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB0 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1' as VAR, SUBSTRING(MKB1 FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB1 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL)) as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB2' as VAR, SUBSTRING(MKB2 FROM 1 FOR 250) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB2 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MKB3' as VAR, SUBSTRING(MKB3 FROM 1 FOR 250) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MKB3 is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_USL' as VAR, SUBSTRING(CODE_USL FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and CODE_USL is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_MD' as VAR, SUBSTRING(CODE_MD FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and CODE_MD is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'MSK_OT' as VAR, SUBSTRING(MSK_OT FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and MSK_OT is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_MSK' as VAR, SUBSTRING(CODE_MSK FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and CODE_MSK is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'VID_MP' as VAR, SUBSTRING(VID_MP FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and VID_MP is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'USL_OK' as VAR, SUBSTRING(USL_OK FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and USL_OK is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'PROFIL' as VAR, SUBSTRING(PROFIL FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and PROFIL is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'ISH_MOV' as VAR, SUBSTRING(ISH_MOV FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and ISH_MOV is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'RES_GOSP' as VAR, SUBSTRING(RES_GOSP FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and RES_GOSP is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'SPEC_MD' as VAR, SUBSTRING(SPEC_MD FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and SPEC_MD is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_LPU' as VAR, SUBSTRING(CODE_LPU FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and CODE_LPU is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'VID_TR' as VAR, SUBSTRING(VID_TR FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and VID_TR is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'DOMC_TYPE' as VAR, SUBSTRING(DOMC_TYPE FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and DOMC_TYPE is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'OKATO_INS' as VAR, SUBSTRING(OKATO_INS FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and OKATO_INS is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'EXTR' as VAR, SUBSTRING(EXTR FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and EXTR is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'DN' as VAR, SUBSTRING(DN FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and DN is not null and (MEE >= 0 or EKMP >= 0)
    ) D
    UNION
    select D.MODEL_ID, D.VAR, D.VAL, (row_number() OVER (ORDER BY D.MODEL_ID, D.VAR, D.VAL))-1 as ORD
    from
    (
      SELECT distinct ( :model_id ) as MODEL_ID, 'P_CEL' as VAR, SUBSTRING(P_CEL FROM 1 FOR 20) as VAL FROM SYNC_DATA
      where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and P_CEL is not null and (MEE >= 0 or EKMP >= 0)
    ) D
  ) items  ON

  ( dict.MODEL_ID = :model_id and dict.VAR = items.VAR and dict.VAL = items.VAL )

  WHEN MATCHED THEN UPDATE SET
    dict.model_id = items.MODEL_ID,
    dict.VAR = items.VAR,
    dict.VAL = items.VAL,
    dict.ORD = items.ORD

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    VAR,
    VAL,
    ORD
  )
  VALUES
  (
    items.MODEL_ID,
    items.VAR,
    items.VAL,
    items.ORD
  );

MERGE INTO model_dictionary dict

  USING
  (
    select ( :model_id ) as MODEL_ID, 'PERSCODE' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'PERS_CODE' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MKB1_SHORT' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'MKB1_SHORT' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MKB1_SUPERSHORT' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'MKB1_SUPERSHORT' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MKB0' as VAR, 'zero' as VAL, 0 as ORD from RDB$DATABASE
    UNION                                                                                                                                                                
    select ( :model_id ) as MODEL_ID, 'MKB1' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'MKB1' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MKB2' as VAR, 'zero' as VAL, 0 as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MKB3' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'MKB3' and val <> 'zero') as ORD from RDB$DATABASE
    UNION                                                 
    select ( :model_id ) as MODEL_ID, 'CODE_USL' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'CODE_USL' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'CODE_MD' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'CODE_MD' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'MSK_OT' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'MSK_OT' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'CODE_MSK' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'CODE_MSK' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'VID_MP' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'VID_MP' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'USL_OK' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'USL_OK' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'PROFIL' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'PROFIL' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'ISH_MOV' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'ISH_MOV' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'RES_GOSP' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'RES_GOSP' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'SPEC_MD' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'SPEC_MD' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'CODE_LPU' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'CODE_LPU' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'VID_TR' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'VID_TR' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'DOMC_TYPE' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'DOMC_TYPE' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'OKATO_INS' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'OKATO_INS' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'EXTR' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'EXTR' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'DN' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'DN' and val <> 'zero') as ORD from RDB$DATABASE
    UNION
    select ( :model_id ) as MODEL_ID, 'P_CEL' as VAR, 'zero' as VAL, (select count(*) from model_dictionary where MODEL_ID = :MODEL_ID and VAR = 'P_CEL' and val <> 'zero') as ORD from RDB$DATABASE
  ) items  ON

  ( dict.MODEL_ID = :model_id and dict.VAR = items.VAR and dict.VAL = items.VAL )

  WHEN MATCHED THEN UPDATE SET
    dict.model_id = items.MODEL_ID,
    dict.VAR = items.VAR,
    dict.VAL = items.VAL,
    dict.ORD = items.ORD

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    VAR,
    VAL,
    ORD
  )
  VALUES
  (
    items.MODEL_ID,
    items.VAR,
    items.VAL,
    items.ORD
  );

end
^


SET TERM ; ^

