/*
  Скрипт модернизации Базы Данных от версии 5 к версии 6.
*/

SET TERM ^ ;

ALTER PROCEDURE GET_APPLY_ROWS(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
RETURNS (
  GKEY CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  IDSL CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  MSK_OT VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MSK VARCHAR(20) /* COLLATE NONE - default */,
  VID_MP VARCHAR(20) /* COLLATE NONE - default */,
  USL_OK VARCHAR(20) /* COLLATE NONE - default */,
  PROFIL VARCHAR(20) /* COLLATE NONE - default */,
  MKB1 VARCHAR(20) /* COLLATE NONE - default */,
  MKB2 VARCHAR(250) /* COLLATE NONE - default */,
  CODE_USL VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MD VARCHAR(20) /* COLLATE NONE - default */,
  KOL_USL DOUBLE PRECISION,
  KOL_FACT DOUBLE PRECISION,
  ISH_MOV VARCHAR(20) /* COLLATE NONE - default */,
  RES_GOSP VARCHAR(20) /* COLLATE NONE - default */,
  TARIF_B DOUBLE PRECISION,
  TARIF_S DOUBLE PRECISION,
  TARIF_1K DOUBLE PRECISION,
  SUM_RUB DOUBLE PRECISION,
  VID_TR VARCHAR(20) /* COLLATE NONE - default */,
  EXTR VARCHAR(20) /* COLLATE NONE - default */,
  SOUF DOUBLE PRECISION,
  SPEC_MD VARCHAR(20) /* COLLATE NONE - default */,
  DOMC_TYPE VARCHAR(20) /* COLLATE NONE - default */,
  OKATO_INS VARCHAR(20) /* COLLATE NONE - default */,
  NOVOR VARCHAR(20) /* COLLATE NONE - default */,
  CODE_LPU VARCHAR(20) /* COLLATE NONE - default */,
  VID_SF DOUBLE PRECISION,
  PERSCODE VARCHAR(36) /* COLLATE NONE - default */,
  DATE_IN DATE,
  DATE_OUT DATE,
  TARIF_D DOUBLE PRECISION,
  VID_KOEFF DOUBLE PRECISION,
  USL_TMP DOUBLE PRECISION,
  BIRTHDAY DATE,
  SEX DOUBLE PRECISION,
  COUNTRY DOUBLE PRECISION,
  BIRTHDAY_P DATE,
  INV DOUBLE PRECISION,
  DATE_NPR DATE,
  FOR_POM DOUBLE PRECISION,
  MSE SMALLINT,
  P_CEL VARCHAR(20) /* COLLATE NONE - default */,
  DN VARCHAR(20) /* COLLATE NONE - default */,
  MKB0 VARCHAR(20) /* COLLATE NONE - default */,
  DS_ONK DOUBLE PRECISION,
  KOL_DEF DOUBLE PRECISION,
  MKB_SHORT VARCHAR(4) /* COLLATE NONE - default */,
  MKB_SUPERSHORT VARCHAR(1) /* COLLATE NONE - default */,
  DATE_NPR_OF_WEEK DOUBLE PRECISION,
  DATE_NPR_MONTH DOUBLE PRECISION,
  DATE_NPR_DIF DOUBLE PRECISION,
  DATE_IN_OF_WEEK DOUBLE PRECISION,
  DATE_IN_MONTH DOUBLE PRECISION,
  DATE_OUT_OF_WEEK DOUBLE PRECISION,
  DATE_OUT_MONTH DOUBLE PRECISION,
  DATE_DIFF DOUBLE PRECISION,
  OLD_VAR DOUBLE PRECISION,
  SUM_PER_DAY DOUBLE PRECISION,
  KOL_USL_PER_DAY DOUBLE PRECISION,
  KOL_FACT_PER_DAY DOUBLE PRECISION,
  DATE_NPR_DIF_RATE DOUBLE PRECISION,
  KOL_USLKOL_FACT DOUBLE PRECISION,
  TARIF_BTARIF_D DOUBLE PRECISION,
  TARIF_BSUM_RUB DOUBLE PRECISION,
  KOL_USLKOL_FACT_P DOUBLE PRECISION,
  TARIF_BSUM_RUB_P DOUBLE PRECISION,
  KOL_USL_RATE DOUBLE PRECISION,
  KOL_FACT_RATE DOUBLE PRECISION,
  DIF_OT DOUBLE PRECISION,
  AGGR_LPU_KOL_DEF DOUBLE PRECISION,
  AGGR_LPU_COUNT DOUBLE PRECISION,
  AGGR_LPU_RATE DOUBLE PRECISION,
  AGGR_MSK_OT_KOL_DEF DOUBLE PRECISION,
  AGGR_MSK_OT_COUNT DOUBLE PRECISION,
  AGGR_MSK_OT_RATE DOUBLE PRECISION,
  IS_EKMP DOUBLE PRECISION,
  VID_PROV DOUBLE PRECISION,
  MKB0_ORD INTEGER,
  MKB1_ORD INTEGER,
  MKB2_ORD INTEGER,
  MKB1S_ORD INTEGER,
  MKB1SS_ORD INTEGER,
  CODE_USL_ORD INTEGER,
  CODE_MD_ORD INTEGER,
  PERSCODE_ORD INTEGER,
  MSK_OT_ORD INTEGER,
  CODE_MSK_ORD INTEGER,
  VID_MP_ORD INTEGER,
  USL_OK_ORD INTEGER,
  PROFIL_ORD INTEGER,
  ISH_MOV_ORD INTEGER,
  RES_GOSP_ORD INTEGER,
  SPEC_MD_ORD INTEGER,
  CODE_LPU_ORD INTEGER,
  VID_TR_ORD INTEGER,
  DOMC_TYPE_ORD INTEGER,
  OKATO_INS_ORD INTEGER,
  EXTR_ORD INTEGER,
  DN_ORD INTEGER,
  P_CEL_ORD INTEGER)
AS
BEGIN
  SUSPEND;
END
^


/******************************************************************************/
/****            Altering stored procedures (with empty bodies)            ****/
/******************************************************************************/
ALTER PROCEDURE MAKE_DICTIONARY_TMP(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
AS
BEGIN
  EXIT;
END
^


/******************************************************************************/
/****                      Altering stored procedures                      ****/
/******************************************************************************/
ALTER PROCEDURE GET_APPLY_ROWS(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
RETURNS (
  GKEY CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  IDSL CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  MSK_OT VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MSK VARCHAR(20) /* COLLATE NONE - default */,
  VID_MP VARCHAR(20) /* COLLATE NONE - default */,
  USL_OK VARCHAR(20) /* COLLATE NONE - default */,
  PROFIL VARCHAR(20) /* COLLATE NONE - default */,
  MKB1 VARCHAR(20) /* COLLATE NONE - default */,
  MKB2 VARCHAR(250) /* COLLATE NONE - default */,
  CODE_USL VARCHAR(20) /* COLLATE NONE - default */,
  CODE_MD VARCHAR(20) /* COLLATE NONE - default */,
  KOL_USL DOUBLE PRECISION,
  KOL_FACT DOUBLE PRECISION,
  ISH_MOV VARCHAR(20) /* COLLATE NONE - default */,
  RES_GOSP VARCHAR(20) /* COLLATE NONE - default */,
  TARIF_B DOUBLE PRECISION,
  TARIF_S DOUBLE PRECISION,
  TARIF_1K DOUBLE PRECISION,
  SUM_RUB DOUBLE PRECISION,
  VID_TR VARCHAR(20) /* COLLATE NONE - default */,
  EXTR VARCHAR(20) /* COLLATE NONE - default */,
  SOUF DOUBLE PRECISION,
  SPEC_MD VARCHAR(20) /* COLLATE NONE - default */,
  DOMC_TYPE VARCHAR(20) /* COLLATE NONE - default */,
  OKATO_INS VARCHAR(20) /* COLLATE NONE - default */,
  NOVOR VARCHAR(20) /* COLLATE NONE - default */,
  CODE_LPU VARCHAR(20) /* COLLATE NONE - default */,
  VID_SF DOUBLE PRECISION,
  PERSCODE VARCHAR(36) /* COLLATE NONE - default */,
  DATE_IN DATE,
  DATE_OUT DATE,
  TARIF_D DOUBLE PRECISION,
  VID_KOEFF DOUBLE PRECISION,
  USL_TMP DOUBLE PRECISION,
  BIRTHDAY DATE,
  SEX DOUBLE PRECISION,
  COUNTRY DOUBLE PRECISION,
  BIRTHDAY_P DATE,
  INV DOUBLE PRECISION,
  DATE_NPR DATE,
  FOR_POM DOUBLE PRECISION,
  MSE SMALLINT,
  P_CEL VARCHAR(20) /* COLLATE NONE - default */,
  DN VARCHAR(20) /* COLLATE NONE - default */,
  MKB0 VARCHAR(20) /* COLLATE NONE - default */,
  DS_ONK DOUBLE PRECISION,
  KOL_DEF DOUBLE PRECISION,
  MKB_SHORT VARCHAR(4) /* COLLATE NONE - default */,
  MKB_SUPERSHORT VARCHAR(1) /* COLLATE NONE - default */,
  DATE_NPR_OF_WEEK DOUBLE PRECISION,
  DATE_NPR_MONTH DOUBLE PRECISION,
  DATE_NPR_DIF DOUBLE PRECISION,
  DATE_IN_OF_WEEK DOUBLE PRECISION,
  DATE_IN_MONTH DOUBLE PRECISION,
  DATE_OUT_OF_WEEK DOUBLE PRECISION,
  DATE_OUT_MONTH DOUBLE PRECISION,
  DATE_DIFF DOUBLE PRECISION,
  OLD_VAR DOUBLE PRECISION,
  SUM_PER_DAY DOUBLE PRECISION,
  KOL_USL_PER_DAY DOUBLE PRECISION,
  KOL_FACT_PER_DAY DOUBLE PRECISION,
  DATE_NPR_DIF_RATE DOUBLE PRECISION,
  KOL_USLKOL_FACT DOUBLE PRECISION,
  TARIF_BTARIF_D DOUBLE PRECISION,
  TARIF_BSUM_RUB DOUBLE PRECISION,
  KOL_USLKOL_FACT_P DOUBLE PRECISION,
  TARIF_BSUM_RUB_P DOUBLE PRECISION,
  KOL_USL_RATE DOUBLE PRECISION,
  KOL_FACT_RATE DOUBLE PRECISION,
  DIF_OT DOUBLE PRECISION,
  AGGR_LPU_KOL_DEF DOUBLE PRECISION,
  AGGR_LPU_COUNT DOUBLE PRECISION,
  AGGR_LPU_RATE DOUBLE PRECISION,
  AGGR_MSK_OT_KOL_DEF DOUBLE PRECISION,
  AGGR_MSK_OT_COUNT DOUBLE PRECISION,
  AGGR_MSK_OT_RATE DOUBLE PRECISION,
  IS_EKMP DOUBLE PRECISION,
  VID_PROV DOUBLE PRECISION,
  MKB0_ORD INTEGER,
  MKB1_ORD INTEGER,
  MKB2_ORD INTEGER,
  MKB1S_ORD INTEGER,
  MKB1SS_ORD INTEGER,
  CODE_USL_ORD INTEGER,
  CODE_MD_ORD INTEGER,
  PERSCODE_ORD INTEGER,
  MSK_OT_ORD INTEGER,
  CODE_MSK_ORD INTEGER,
  VID_MP_ORD INTEGER,
  USL_OK_ORD INTEGER,
  PROFIL_ORD INTEGER,
  ISH_MOV_ORD INTEGER,
  RES_GOSP_ORD INTEGER,
  SPEC_MD_ORD INTEGER,
  CODE_LPU_ORD INTEGER,
  VID_TR_ORD INTEGER,
  DOMC_TYPE_ORD INTEGER,
  OKATO_INS_ORD INTEGER,
  EXTR_ORD INTEGER,
  DN_ORD INTEGER,
  P_CEL_ORD INTEGER)
AS
declare variable DATE_IN_MED date;
declare variable DATE_OUT_MED date;
declare variable BIRTHDAY_MED date;
declare variable BIRTHDAY_P_MED date;
declare variable DATE_NPR_MED date;
declare variable DATE_IN_VAR date;
declare variable DATE_OUT_VAR date;
declare variable BIRTHDAY_VAR date;
declare variable DATE_NPR_VAR date;
declare variable MODEL_ID_VAR char(16) character set OCTETS;
declare variable MKB0_VAR varchar(20);
declare variable MKB1_VAR varchar(20);
declare variable MKB2_VAR varchar(250);
declare variable MKB1_S_VAR varchar(4);
declare variable MKB1_SS_VAR varchar(1);
declare variable CODE_USL_VAR varchar(20);
declare variable CODE_MD_VAR varchar(20);
declare variable PERSCODE_VAR varchar(36);
declare variable MSK_OT_VAR varchar(20);
declare variable CODE_MSK_VAR varchar(20);
declare variable VID_MP_VAR varchar(20);
declare variable USL_OK_VAR varchar(20);
declare variable PROFIL_VAR varchar(20);
declare variable ISH_MOV_VAR varchar(20);
declare variable RES_GOSP_VAR varchar(20);
declare variable SPEC_MD_VAR varchar(20);
declare variable CODE_LPU_VAR varchar(20);
declare variable VID_TR_VAR varchar(20);
declare variable DOMC_TYPE_VAR varchar(20);
declare variable OKATO_INS_VAR varchar(20);
declare variable EXTR_VAR varchar(20);
declare variable DN_VAR varchar(20);
declare variable P_CEL_VAR varchar(20);
declare variable MEE_VAL smallint;
declare variable EKMP_VAL smallint;
begin

if (:model_type = 0) then
begin
  :MEE_VAL = -1;
  :EKMP_VAL = 2;
end
else
begin
  :MEE_VAL = 2;
  :EKMP_VAL = -1;
end

select
  DATE_IN_RET, DATE_OUT_RET, BIRTHDAY_RET, BIRTHDAY_P_RET, DATE_NPR_RET
from
  MEDIAN_VALUES(:PERIOD_BEGIN, :PERIOD_END, :MODEL_TYPE)
into
  DATE_IN_MED, DATE_OUT_MED, BIRTHDAY_MED, BIRTHDAY_P_MED, DATE_NPR_MED;

:MODEL_ID_VAR = :MODEL_ID;

EXECUTE PROCEDURE make_dictionary_tmp(:MODEL_ID_VAR, :PERIOD_BEGIN, :PERIOD_END, :MODEL_TYPE);
EXECUTE PROCEDURE MAKE_AGGR_tmp(:MODEL_ID_VAR, :PERIOD_BEGIN, :PERIOD_END, :MODEL_TYPE);

for select
  GKEY,
  IDSL,
  MSK_OT,
  CODE_MSK,
  VID_MP,
  USL_OK,
  PROFIL,
  MKB1,
  MKB2,
  CODE_USL,
  CODE_MD,
  cast(KOL_USL as float),
  cast(KOL_FACT as float),
  ISH_MOV,
  RES_GOSP,
  cast(TARIF_B as float),
  cast(TARIF_S as float),
  cast(TARIF_1K as float),
  cast(SUM_RUB as float),
  VID_TR,
  cast(EXTR as varchar(20)),
  cast(SOUF as float),
  SPEC_MD,
  DOMC_TYPE,
  OKATO_INS,
  cast(NOVOR as varchar(20)),
  CODE_LPU,
  cast(VID_SF as float),
  PERSCODE,
  cast(TARIF_D as float),
  cast(VID_KOEFF as float),
  cast(USL_TMP as float),
  cast(SEX as float),
  cast(COUNTRY as float),
  cast(INV as float),
  cast(FOR_POM as float),
  cast(COALESCE(MSE, 0) as float),
  P_CEL,
  cast(DN as varchar(20)),
  MKB0,
  cast(DS_ONK as float),
  DATE_IN,
  DATE_OUT,
  DATE_NPR,
  BIRTHDAY,
  BIRTHDAY_P,
  SUBSTRING(MKB1 FROM 1 FOR 4) as MKB_SHORT,
  SUBSTRING(MKB1 FROM 1 FOR 1) as MKB_SUPERSHORT,
  :DATE_NPR_OF_WEEK,
  :DATE_NPR_MONTH,
  :DATE_NPR_DIF,
  :DATE_IN_OF_WEEK,
  :DATE_IN_MONTH,
  :DATE_OUT_OF_WEEK,
  :DATE_OUT_MONTH,
  :DATE_DIFF,
  :OLD_VAR,
  :Sum_per_Day,
  :KOL_USL_per_Day,
  :KOL_FACT_per_Day,
  :DATE_NPR_DIF_RATE,
  :KOL_USLKOL_FACT,
  :TARIF_BTARIF_D,
  :TARIF_BSUM_RUB,
  :KOL_USLKOL_FACT_P,
  :TARIF_BSUM_RUB_P,
  :KOL_USL_RATE,
  :KOL_FACT_RATE,
  :DIF_OT,
  case
    when :MODEL_TYPE = 0 and MEE > 0 then 1
    when :MODEL_TYPE = 1 and EKMP > 0 then 1
    else 0
  end as KOL_DEF,
  :aggr_lpu_KOL_DEF,
  :aggr_lpu_COUNT,
  :aggr_lpu_RATE,
  :aggr_MSK_OT_KOL_DEF,
  :aggr_MSK_OT_COUNT,
  :aggr_MSK_OT_RATE,
  :IS_EKMP as IS_EKMP,
  VID_PROV,
  :MKB0_ORD,
  :MKB1_ORD,
  :MKB2_ORD,
  :MKB1S_ORD,
  :MKB1SS_ORD,
  :CODE_USL_ORD,
  :CODE_MD_ORD,
  :PERSCODE_ORD,
  :MSK_OT_ORD,
  :CODE_MSK_ORD,
  :VID_MP_ORD,
  :USL_OK_ORD,
  :PROFIL_ORD,
  :ISH_MOV_ORD,
  :RES_GOSP_ORD,
  :SPEC_MD_ORD,
  :CODE_LPU_ORD,
  :VID_TR_ORD,
  :DOMC_TYPE_ORD,
  :OKATO_INS_ORD,
  :P_CEL_ORD
from
  sync_data where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
into
  :GKEY,
  :IDSL,
  :MSK_OT,
  :CODE_MSK,
  :VID_MP,
  :USL_OK,
  :PROFIL,
  :MKB1,
  :MKB2,
  :CODE_USL,
  :CODE_MD,
  :KOL_USL,
  :KOL_FACT,
  :ISH_MOV,
  :RES_GOSP,
  :TARIF_B,
  :TARIF_S,
  :TARIF_1K,
  :SUM_RUB,
  :VID_TR,
  :EXTR,
  :SOUF,
  :SPEC_MD,
  :DOMC_TYPE,
  :OKATO_INS,
  :NOVOR,
  :CODE_LPU,
  :VID_SF,
  :PERSCODE,
  :TARIF_D,
  :VID_KOEFF,
  :USL_TMP,
  :SEX,
  :COUNTRY,
  :INV,
  :FOR_POM,
  :MSE,
  :P_CEL,
  :DN,
  :MKB0,
  :DS_ONK,
  :DATE_IN,
  :DATE_OUT,
  :DATE_NPR,
  :BIRTHDAY,
  :BIRTHDAY_P,
  :MKB_SHORT,
  :MKB_SUPERSHORT,
  :DATE_NPR_OF_WEEK,
  :DATE_NPR_MONTH,
  :DATE_NPR_DIF,
  :DATE_IN_OF_WEEK,
  :DATE_IN_MONTH,
  :DATE_OUT_OF_WEEK,
  :DATE_OUT_MONTH,
  :DATE_DIFF,
  :OLD_VAR,
  :Sum_per_Day,
  :KOL_USL_per_Day,
  :KOL_FACT_per_Day,
  :DATE_NPR_DIF_RATE,
  :KOL_USLKOL_FACT,
  :TARIF_BTARIF_D,
  :TARIF_BSUM_RUB,
  :KOL_USLKOL_FACT_P,
  :TARIF_BSUM_RUB_P,
  :KOL_USL_RATE,
  :KOL_FACT_RATE,
  :DIF_OT,
  :KOL_DEF,
  :aggr_lpu_KOL_DEF,
  :aggr_lpu_COUNT,
  :aggr_lpu_RATE,
  :aggr_MSK_OT_KOL_DEF,
  :aggr_MSK_OT_COUNT,
  :aggr_MSK_OT_RATE,
  :IS_EKMP,
  :VID_PROV,
  :MKB0_ORD,
  :MKB1_ORD,
  :MKB2_ORD,
  :MKB1S_ORD,
  :MKB1SS_ORD,
  :CODE_USL_ORD,
  :CODE_MD_ORD,
  :PERSCODE_ORD,
  :MSK_OT_ORD,
  :CODE_MSK_ORD,
  :VID_MP_ORD,
  :USL_OK_ORD,
  :PROFIL_ORD,
  :ISH_MOV_ORD,
  :RES_GOSP_ORD,
  :SPEC_MD_ORD,
  :CODE_LPU_ORD,
  :VID_TR_ORD,
  :DOMC_TYPE_ORD,
  :OKATO_INS_ORD,
  :P_CEL_ORD
do
begin
  if (MSK_OT is null ) then MSK_OT = 'zero'; else MSK_OT = MSK_OT;

  if (CODE_MSK is null ) then CODE_MSK = 'zero'; else CODE_MSK = CODE_MSK;

  if (VID_MP is null ) then VID_MP = 'zero'; else VID_MP = VID_MP;

  if (USL_OK is null ) then USL_OK = 'zero'; else USL_OK = USL_OK;

  if (PROFIL is null ) then PROFIL = 'zero'; else PROFIL = PROFIL;

  if (MKB1 is null ) then MKB1 = 'zero'; else MKB1 = MKB1;

  if (MKB2 is null ) then MKB2 = 'zero'; else MKB2 = MKB2;

  if (CODE_USL is null ) then CODE_USL = 'zero'; else CODE_USL = CODE_USL;

  if (CODE_MD is null ) then CODE_MD = 'zero'; else CODE_MD = CODE_MD;

  if (KOL_USL is null ) then KOL_USL = 0; else KOL_USL = KOL_USL;

  if (KOL_FACT is null ) then KOL_FACT = 0; else KOL_FACT = KOL_FACT;

  if (ISH_MOV is null ) then ISH_MOV = 'zero'; else ISH_MOV = ISH_MOV;

  if (RES_GOSP is null ) then RES_GOSP = 'zero'; else RES_GOSP = RES_GOSP;

  if (TARIF_B is null ) then TARIF_B = 0; else TARIF_B = TARIF_B;

  if (TARIF_S is null ) then TARIF_S = 0; else TARIF_S = TARIF_S;

  if (TARIF_1K is null ) then TARIF_1K = 0; else TARIF_1K = TARIF_1K;

  if (SUM_RUB is null ) then SUM_RUB = 0; else SUM_RUB = SUM_RUB;

  if (VID_TR is null ) then VID_TR = 'zero'; else VID_TR = VID_TR;

  if (EXTR is null ) then EXTR = 'zero'; else EXTR = EXTR;

  if (SOUF is null ) then SOUF = 0; else SOUF = SOUF;

  if (SPEC_MD is null ) then SPEC_MD = 'zero'; else SPEC_MD = SPEC_MD;

  if (DOMC_TYPE is null ) then DOMC_TYPE = 'zero'; else DOMC_TYPE = DOMC_TYPE;

  if (OKATO_INS is null ) then OKATO_INS = 'zero'; else OKATO_INS = OKATO_INS;

  if (NOVOR is null ) then NOVOR = 0; else NOVOR = NOVOR;

  if (CODE_LPU is null ) then CODE_LPU = 'zero'; else CODE_LPU = CODE_LPU;

  if (VID_SF is null ) then VID_SF = 0; else VID_SF = VID_SF;

  if (PERSCODE is null ) then PERSCODE = 'zero'; else PERSCODE = PERSCODE;

  if (TARIF_D is null ) then TARIF_D = 0; else TARIF_D = TARIF_D;

  if (VID_KOEFF is null ) then VID_KOEFF = 0; else VID_KOEFF = VID_KOEFF;

  if (USL_TMP is null ) then USL_TMP = 0; else USL_TMP = USL_TMP;

  if (SEX is null ) then SEX = 0; else SEX = SEX;

  if (COUNTRY is null ) then COUNTRY = 0; else COUNTRY = COUNTRY;

  if (INV is null ) then INV = 0; else INV = INV;

  if (FOR_POM is null ) then FOR_POM = 0; else FOR_POM = FOR_POM;

  if (MSE is null ) then MSE = 0; else MSE = MSE;

  if (P_CEL is null ) then P_CEL = 'zero'; else P_CEL = P_CEL;

  if (DN is null ) then DN = 'zero'; else DN = DN;

  if (MKB0 is null ) then MKB0 = 'zero'; else MKB0 = MKB0;

  :MKB0_VAR = MKB0;
  :MKB1_VAR = MKB1;
  :MKB2_VAR = MKB2;

  :MKB1_S_VAR = MKB_SHORT;
  :MKB1_SS_VAR = MKB_SUPERSHORT;

  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB0' and md.val = :MKB0_VAR into :MKB0_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB1' and md.val = :MKB1_VAR into :MKB1_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB2' and md.val = :MKB2_VAR into :MKB2_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB1_SHORT' and md.val = :MKB1_S_VAR into :MKB1S_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MKB1_SUPERSHORT' and md.val = :MKB1_SS_VAR into :MKB1SS_ORD;

  :CODE_USL_VAR = :CODE_USL;
  :CODE_MD_VAR = :CODE_MD;

  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_USL' and md.val = :CODE_USL_VAR into :CODE_USL_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_MD' and md.val = :CODE_MD_VAR into :CODE_MD_ORD;

  :PERSCODE_VAR = :PERSCODE;

  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'PERSCODE' and md.val = :PERSCODE_VAR into :PERSCODE_ORD;

  :CODE_LPU_VAR = :CODE_LPU;

  select CNT, DEF FROM model_aggr_tmp mla where mla.model_id = :MODEL_ID_VAR and mla.KIND = :MODEL_TYPE and mla.var = 'CODE_LPU' and mla.val = :CODE_LPU_VAR into :aggr_lpu_COUNT, :aggr_lpu_KOL_DEF;
  :aggr_lpu_RATE = (:aggr_lpu_KOL_DEF + 1) / (:aggr_lpu_COUNT + 10);

  :MSK_OT_VAR = :MSK_OT;
  :CODE_MSK_VAR = :CODE_MSK;
  :VID_MP_VAR = :VID_MP;
  :USL_OK_VAR = :USL_OK;
  :PROFIL_VAR = :PROFIL;
  :ISH_MOV_VAR = :ISH_MOV;
  :RES_GOSP_VAR = :RES_GOSP;
  :SPEC_MD_VAR = :SPEC_MD;
  :VID_TR_VAR = :VID_TR;
  :DOMC_TYPE_VAR = :DOMC_TYPE;
  :OKATO_INS_VAR = :OKATO_INS;
  :EXTR_VAR = :EXTR;
  :DN_VAR = :DN;
  :P_CEL_VAR = :P_CEL;

  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'MSK_OT' and md.val = :MSK_OT_VAR into :MSK_OT_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_MSK' and md.val = :CODE_MSK_VAR into :CODE_MSK_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'VID_MP' and md.val = :VID_MP_VAR into :VID_MP_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'USL_OK' and md.val = :USL_OK_VAR into :USL_OK_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'PROFIL' and md.val = :PROFIL_VAR into :PROFIL_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'ISH_MOV' and md.val = :ISH_MOV_VAR into :ISH_MOV_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'RES_GOSP' and md.val = :RES_GOSP_VAR into :RES_GOSP_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'SPEC_MD' and md.val = :SPEC_MD_VAR into :SPEC_MD_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'CODE_LPU' and md.val = :CODE_LPU_VAR into :CODE_LPU_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'VID_TR' and md.val = :VID_TR_VAR into :VID_TR_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'DOMC_TYPE' and md.val = :DOMC_TYPE_VAR into :DOMC_TYPE_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'OKATO_INS' and md.val = :OKATO_INS_VAR into :OKATO_INS_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'EXTR' and md.val = :EXTR_VAR into :EXTR_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'DN' and md.val = :DN_VAR into :DN_ORD;
  select ORD FROM model_dictionary_tmp md where md.model_id = :MODEL_ID_VAR and md.var = 'P_CEL' and md.val = :P_CEL_VAR into :P_CEL_ORD;

  select CNT, DEF FROM model_aggr_tmp mmoa where mmoa.model_id = :MODEL_ID_VAR and mmoa.KIND = :MODEL_TYPE and mmoa.var = 'MSK_OT' and mmoa.val = :MSK_OT_VAR into :AGGR_MSK_OT_COUNT, :AGGR_MSK_OT_KOL_DEF;
  :aggr_MSK_OT_RATE = (aggr_MSK_OT_KOL_DEF + 1) / cast((AGGR_MSK_OT_COUNT + 10) as float);

  if (DS_ONK is null ) then DS_ONK = 0; else DS_ONK = DS_ONK;

  if (DATE_IN is null )
  then
  begin
    DATE_IN = DATE_IN_MED;
    DATE_IN_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_IN_MED);
    DATE_IN_MONTH = EXTRACT(DAY FROM DATE_IN_MED);
  end
  else
  begin
    DATE_IN = DATE_IN;
    DATE_IN_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_IN);
    DATE_IN_MONTH = EXTRACT(DAY FROM DATE_IN);
  end

  DATE_IN_VAR = DATE_IN;

  if (DATE_OUT is null )
  then
  begin
    DATE_OUT = DATE_OUT_MED;
    DATE_OUT_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_OUT_MED);
    DATE_OUT_MONTH = EXTRACT(DAY FROM DATE_OUT_MED);
  end
  else
  begin
    DATE_OUT = DATE_OUT;
    DATE_OUT_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_OUT);
    DATE_OUT_MONTH = EXTRACT(DAY FROM DATE_OUT);
  end

  DATE_OUT_VAR = DATE_OUT;

  if (DATE_NPR is null )
  then
  begin
    DATE_NPR = DATE_NPR_MED;
    DATE_NPR_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_NPR_MED);
    DATE_NPR_MONTH = EXTRACT(DAY FROM DATE_NPR_MED);
  end
  else
  begin
    DATE_NPR = DATE_NPR;
    DATE_NPR_OF_WEEK = EXTRACT(WEEKDAY FROM DATE_NPR);
    DATE_NPR_MONTH = EXTRACT(DAY FROM DATE_NPR);
  end

  DATE_NPR_VAR = DATE_NPR;

  DATE_NPR_DIF = datediff (day, DATE_NPR_VAR, DATE_IN_VAR) + 1/cast(6 as float);

  DATE_DIFF = cast( datediff (day, DATE_OUT_VAR, DATE_IN_VAR) as float) + 1/cast(6 as float);

  if (BIRTHDAY is null ) then BIRTHDAY = BIRTHDAY_MED; else BIRTHDAY = BIRTHDAY;

  BIRTHDAY_VAR = BIRTHDAY;

  if (BIRTHDAY_P is null ) then BIRTHDAY_P = BIRTHDAY_P_MED; else BIRTHDAY_P = BIRTHDAY_P;

  OLD_VAR =  cast( datediff (year, DATE_IN_VAR, BIRTHDAY_VAR) as float);

  Sum_per_Day = SUM_RUB / cast(DATE_DIFF as float);

  KOL_USL_per_Day =   KOL_USL /  cast(DATE_DIFF as float);

  KOL_FACT_per_Day = KOL_FACT / cast(DATE_DIFF as float);

  DATE_NPR_DIF_RATE = DATE_NPR_DIF / cast(DATE_DIFF as float);

  KOL_USLKOL_FACT = KOL_USL - KOL_FACT;
  TARIF_BTARIF_D = TARIF_B- TARIF_D;
  TARIF_BSUM_RUB = TARIF_B - SUM_RUB;
  KOL_USLKOL_FACT_p = KOL_USL + KOL_FACT;
  TARIF_BSUM_RUB_p = TARIF_B + SUM_RUB;
  KOL_USL_rate = SUM_RUB / ( KOL_USL + 0.01);
  KOL_FACT_rate = SUM_RUB / ( KOL_FACT + 0.01);

  if (NOVOR = 0)
  then       
     NOVOR = 0;
  else
     NOVOR = 1;

  if (SEX = 2)
  then
     SEX = 1;
  else
     SEX = 0;

  if (MSK_OT <> CODE_MSK)
  then
     DIF_OT = 1;
  else
     DIF_OT = 0;

  IS_EKMP = 0;

  suspend;
end

end
^

ALTER PROCEDURE MAKE_AGGR_TMP(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
AS
begin
/*
if (:model_type = 0) then
begin
  :MEE_VAL = -1;
  :EKMP_VAL = 2;
end
else
begin
  :MEE_VAL = 2;
  :EKMP_VAL = -1;
end
*/
/*
MERGE INTO model_aggr_tmp mla
USING
(
  select
    :model_id as MODEL_ID,
    :MODEL_TYPE as KIND,
    'CODE_LPU' as VAR,
    t.CODE_LPU_VAL as CODE_LPU_VAL,
    t.CNT as CNT,
    case
      when :MODEL_TYPE = 0 then MEE_DEF
      when :MODEL_TYPE = 1 then EKMP_DEF
    else 0
    end as DEF
  from
  (
    select
      CODE_LPU as CODE_LPU_VAL,
      count(*) as CNT,
      sum(mee) as MEE_DEF,
      sum(ekmp) as EKMP_DEF
    from
      sync_data where CODE_LPU is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
    group by
      CODE_LPU
  ) t
) items  ON

( mla.model_id = items.MODEL_ID and mla.kind = items.kind and mla.var = items.var and mla.val = items.CODE_LPU_VAL )

  WHEN MATCHED THEN UPDATE SET
    mla.MODEL_ID = items.MODEL_ID,
    mla.KIND = items.KIND,
    mla.VAR = items.VAR,
    mla.VAL = items.CODE_LPU_VAL,
    mla.CNT = items.CNT,
    mla.DEF = items.DEF

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    KIND,
    VAR,
    VAL,
    CNT,
    DEF
  )
  VALUES
  (
    items.MODEL_ID,
    items.KIND,
    items.VAR,
    items.CODE_LPU_VAL,
    items.CNT,
    items.DEF
  );
*/
MERGE INTO model_aggr_tmp mla
USING
(
  select
    t.model_id,
    t.kind,
    'CODE_LPU' as VAR,
    t.VAL as CODE_LPU_VAL,
    coalesce(ma.cnt, 0) as CNT,
    coalesce(ma.def, 0) as DEF
  from
  (
    select distinct
      :model_id as model_id,
      :MODEL_TYPE as kind,
      CODE_LPU as VAL
    from
      sync_data
    where
      date_ot_per >= :PERIOD_BEGIN and date_ot_per <= :PERIOD_END
  ) t
  left join model_aggr ma on ma.model_id = t.model_id and ma.kind = t.kind and ma.VAR = 'CODE_LPU' and ma.VAL = t.VAL
) items  ON

( mla.model_id = items.MODEL_ID and mla.kind = items.kind and mla.var = items.var and mla.val = items.CODE_LPU_VAL )

  WHEN MATCHED THEN UPDATE SET
    mla.MODEL_ID = items.MODEL_ID,
    mla.KIND = items.KIND,
    mla.VAR = items.VAR,
    mla.VAL = items.CODE_LPU_VAL,
    mla.CNT = items.CNT,
    mla.DEF = items.DEF

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    KIND,
    VAR,
    VAL,
    CNT,
    DEF
  )
  VALUES
  (
    items.MODEL_ID,
    items.KIND,
    items.VAR,
    items.CODE_LPU_VAL,
    items.CNT,
    items.DEF
  );
/*
MERGE INTO model_aggr_tmp mmoa
USING
(
  select
    :model_id as MODEL_ID,
    :MODEL_TYPE as KIND,
    'MSK_OT' as VAR,
    t.MSK_OT_VAL as MSK_OT_VAL,
    t.CNT as CNT,
    case
      when :MODEL_TYPE = 0 then MEE_DEF
      when :MODEL_TYPE = 1 then EKMP_DEF
    else 0
    end as DEF
  from
  (
    select
      MSK_OT as MSK_OT_VAL,
      count(*) as CNT,
      sum(mee) as MEE_DEF,
      sum(ekmp) as EKMP_DEF
    from
      sync_data where MSK_OT is not null and (DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END) and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
    group by
      MSK_OT
  ) t
) items  ON

( mmoa.model_id = items.MODEL_ID AND mmoa.kind = items.kind AND mmoa.var = items.var and mmoa.val = items.MSK_OT_VAL )

  WHEN MATCHED THEN UPDATE SET
    mmoa.MODEL_ID  = items.MODEL_ID,
    mmoa.KIND = items.KIND,
    mmoa.VAR = items.VAR,
    mmoa.VAL = items.MSK_OT_VAL,
    mmoa.CNT = items.CNT,
    mmoa.DEF = items.DEF

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    KIND,
    VAR,
    VAL,
    CNT,
    DEF
  )
  VALUES
  (
    items.MODEL_ID,
    items.KIND,
    items.VAR,
    items.MSK_OT_VAL,
    items.CNT,
    items.DEF
  );
*/
MERGE INTO model_aggr_tmp mla
USING
(
  select
    t.model_id,
    t.kind,
    'MSK_OT' as VAR,
    t.VAL as CODE_LPU_VAL,
    coalesce(ma.cnt, 0) as CNT,
    coalesce(ma.def, 0) as DEF
  from
  (
    select distinct
      :model_id as model_id,
      :MODEL_TYPE as kind,
      MSK_OT as VAL
    from
      sync_data
    where
      date_ot_per >= :PERIOD_BEGIN and date_ot_per <= :PERIOD_END
  ) t
  left join model_aggr ma on ma.model_id = t.model_id and ma.kind = t.kind and ma.VAR = 'MSK_OT' and ma.VAL = t.VAL
) items  ON

( mla.model_id = items.MODEL_ID and mla.kind = items.kind and mla.var = items.var and mla.val = items.CODE_LPU_VAL )

  WHEN MATCHED THEN UPDATE SET
    mla.MODEL_ID = items.MODEL_ID,
    mla.KIND = items.KIND,
    mla.VAR = items.VAR,
    mla.VAL = items.CODE_LPU_VAL,
    mla.CNT = items.CNT,
    mla.DEF = items.DEF

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    KIND,
    VAR,
    VAL,
    CNT,
    DEF
  )
  VALUES
  (
    items.MODEL_ID,
    items.KIND,
    items.VAR,
    items.CODE_LPU_VAL,
    items.CNT,
    items.DEF
  );
end
^

ALTER PROCEDURE MAKE_DICTIONARY_TMP(
  MODEL_ID CHAR(16) CHARACTER SET OCTETS /* COLLATE OCTETS - default */,
  PERIOD_BEGIN DATE,
  PERIOD_END DATE,
  MODEL_TYPE SMALLINT)
AS
declare variable MEE_VAL smallint;
declare variable EKMP_VAL smallint;
begin

if (:model_type = 0) then
begin
  :MEE_VAL = -1;
  :EKMP_VAL = 2;
end
else
begin
  :MEE_VAL = 2;
  :EKMP_VAL = -1;
end

MERGE INTO model_dictionary_tmp dict

  USING
  (
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = M.MODEL_ID and mdmf.var = 'PERSCODE'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'PERSCODE' as VAR, COALESCE(cast(PERSCODE as varchar(36)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = M.MODEL_ID and mdmf.var = 'MKB1_SHORT'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1_SHORT' as VAR, COALESCE(SUBSTRING(MKB1 FROM 1 FOR 4), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MKB1_SUPERSHORT'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1_SUPERSHORT' as VAR, COALESCE(SUBSTRING(MKB1 FROM 1 FOR 1), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MKB0'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB0' as VAR, COALESCE(cast(MKB0 as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MKB1'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB1' as VAR, COALESCE(cast(MKB1 as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MKB2'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB2' as VAR, COALESCE(cast(MKB2 as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MKB3'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MKB3' as VAR, COALESCE(cast(MKB3 as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'CODE_USL'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_USL' as VAR, COALESCE(cast(CODE_USL as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'CODE_MD'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_MD' as VAR, COALESCE(cast(CODE_MD as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'MSK_OT'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'MSK_OT' as VAR, COALESCE(cast(MSK_OT as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'CODE_MSK'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_MSK' as VAR, COALESCE(cast(CODE_MSK as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'VID_MP'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'VID_MP' as VAR, COALESCE(cast(VID_MP as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'USL_OK'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'USL_OK' as VAR, COALESCE(cast(USL_OK as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'PROFIL'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'PROFIL' as VAR, COALESCE(cast(PROFIL as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'ISH_MOV'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'ISH_MOV' as VAR, COALESCE(cast(ISH_MOV as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'RES_GOSP'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'RES_GOSP' as VAR, COALESCE(cast(RES_GOSP as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'SPEC_MD'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'SPEC_MD' as VAR, COALESCE(cast(SPEC_MD as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'CODE_LPU'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'CODE_LPU' as VAR, COALESCE(cast(CODE_LPU as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'VID_TR'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'VID_TR' as VAR, COALESCE(cast(VID_TR as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'DOMC_TYPE'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'DOMC_TYPE' as VAR, COALESCE(cast(DOMC_TYPE as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'OKATO_INS'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'OKATO_INS' as VAR, COALESCE(cast(OKATO_INS as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'EXTR'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'EXTR' as VAR, COALESCE(cast(EXTR as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'DN'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'DN' as VAR, COALESCE(cast(DN as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
    UNION
    select M.MODEL_ID, M.VAR, M.VAL,
      COALESCE(
        M.ORD,
        (SELECT ORD FROM MODEL_DICTIONARY MD WHERE MD.MODEL_ID = M.MODEL_ID and MD.VAR = M.VAR and MD.VAL = (select VAL from model_dictionary_most_freq mdmf where mdmf.MODEL_ID = :model_id and mdmf.var = 'P_CEL'))
      ) AS ORD
    from
    (
      select D.MODEL_ID, D.VAR, D.VAL, MD.ORD
      from
      (
        SELECT distinct ( :model_id ) as MODEL_ID, 'P_CEL' as VAR, COALESCE(cast(P_CEL as varchar(20)), 'zero') as VAL FROM SYNC_DATA
        where DATE_OT_PER >= :PERIOD_BEGIN and DATE_OT_PER <= :PERIOD_END and (MEE >= :MEE_VAL or EKMP >= :EKMP_VAL)
      ) D
      LEFT JOIN MODEL_DICTIONARY MD on MD.MODEL_ID = D.MODEL_ID and MD.VAR = D.VAR and MD.VAL = D.VAL
    ) M
  ) items  ON

  ( dict.MODEL_ID = :model_id and dict.VAR = items.VAR and dict.VAL = items.VAL )

  WHEN MATCHED THEN UPDATE SET
    dict.model_id = items.MODEL_ID,
    dict.VAR = items.VAR,
    dict.VAL = items.VAL,
    dict.ORD = items.ORD

  WHEN NOT MATCHED THEN INSERT
  (
    MODEL_ID,
    VAR,
    VAL,
    ORD
  )
  VALUES
  (
    items.MODEL_ID,
    items.VAR,
    items.VAL,
    items.ORD
  );

end
^

ALTER PROCEDURE VERSION
RETURNS (
  DB_VERSION INTEGER)
AS
begin
  :DB_VERSION = 7;
  suspend;
end
^


SET TERM ; ^

